//////////////////////////////////////////////////////////////
// fmtdlg.cc
//
//
// Copyright (C) 1999 Jonathan R. Hudson
// Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
//   $Log: fmtdlg.cc,v $
//   Revision 1.3  2000/03/16 22:38:51  jrh
//   Updated window positioning
//
//   Revision 1.2  2000/02/20 14:47:52  jrh
//   Windows root fixes
//
//   Revision 1.1  1999/11/09 20:13:15  jrh
//   Initial revision
//
//
//////////////////////////////////////////////////////////////
#ifdef _GNUC_
static char rcsid[] __attribute__ ((unused)) ="$Id: fmtdlg.cc,v 1.3 2000/03/16 22:38:51 jrh Exp $";
#endif

#include "wx/wxprec.h"
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers
#ifndef WX_PRECOMP
# include "wx/wx.h"
#endif
#include "wx/app.h"
#ifndef WX20
#include "wx/statline.h"
#endif

#include "fmtdlg.h"
#include <fstream>

#ifndef WIN32
#define FMTH 220
#else
#define FMTH 260
#endif

BEGIN_EVENT_TABLE(FmtDlg, wxDialog)
    EVT_BUTTON(wxID_OK, FmtDlg::OnOK)
END_EVENT_TABLE()

FmtDlg::~FmtDlg()
{
}

FmtDlg::FmtDlg(wxWindow *parent, char *title="Format") 
        : wxDialog (parent, -1, title, wxDefaultPosition,
                    wxSize(260,FMTH) 
/*, wxDIALOG_MODAL|wxDEFAULT_DIALOG_STYLE*/),
          res(-1)
{
  
    const wxString choices[] = {
        "DD (720Kb)",
        "HD (1440Kb)"
    };
    SetAutoLayout(TRUE);
    wxPanel *panel = new wxPanel(this);
    wxStaticBox *box = new wxStaticBox(panel,-1,"Problem",
                                          wxDefaultPosition,
                                          wxDefaultSize);

    wxStaticText *text = new wxStaticText(panel,-1,
                                          "Can't determine the device/image\n"
                                          "size from the device or image or\n"
                                          "the supplied disk label\n"
                                          "Please select a value",
                                          wxDefaultPosition,
                                          wxDefaultSize);

    rbox = new wxRadioBox(panel, -1, "Size",  
                          wxDefaultPosition,
                          wxDefaultSize,
                          2,choices, 0,
#ifndef WIN32
                          wxRA_SPECIFY_COLS
#else
                          wxRA_SPECIFY_ROWS
#endif
                          );

    wxButton *but1  = new wxButton(panel, wxID_OK, "OK");
    wxButton *but2  = new wxButton(panel, wxID_CANCEL, "Cancel");
    
    wxLayoutConstraints *c = new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 12);
    c->right.SameAs (panel, wxRight, 12);
    c->top.SameAs (panel, wxTop, 20);
    c->height.AsIs();
    text->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (text, wxLeft, -5);
    c->right.SameAs (text, wxRight, -5);
    c->top.SameAs (text, wxTop, -15);
    c->bottom.SameAs (text, wxBottom, -12);
    box->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->centreX.SameAs (panel, wxCentreX);
    c->top.SameAs (box, wxBottom, 12);
    c->width.AsIs() ;
    c->height.AsIs();
    rbox->SetConstraints(c);
#ifndef WX20
    wxStaticLine *ln = new wxStaticLine(panel, -1, 
                                        wxDefaultPosition, wxSize(3,3),
                                        wxHORIZONTAL);
    c = new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 10);
    c->right.SameAs (panel, wxRight, 10);
    c->top.SameAs (rbox, wxBottom, 5);
    c->height.AsIs();
    ln->SetConstraints(c);
#endif
    c =  new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 20);
    c->bottom.SameAs (panel, wxBottom, 5);
    c->width.AsIs() ;
    c->height.AsIs();
    but1->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->right.SameAs (panel, wxRight, 20);
    c->bottom.SameAs (panel, wxBottom, 5);
    c->width.AsIs() ;
    c->height.AsIs();
    but2->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (this, wxLeft);
    c->top.SameAs (this, wxTop);
    c->right.SameAs (this, wxRight);
    c->height.SameAs (this, wxBottom);
    panel->SetConstraints(c);
    Layout();
}

void FmtDlg::OnOK(wxCommandEvent& event)
{
    res = rbox->GetSelection();
    EndModal(wxID_OK);
}
