//////////////////////////////////////////////////////////////
// loadimages.cc
//
//
// Copyright (C) 1999 Jonathan R. Hudson
// Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//   $Log: loadimages.cc,v $
//   Revision 1.2  2000/02/20 14:47:52  jrh
//   Windows root fixes
//
//   Revision 1.1  1999/11/09 20:13:15  jrh
//   Initial revision
//
//
//////////////////////////////////////////////////////////////

#ifdef _GNUC_
static char rcsid[] __attribute__ ((unused)) ="$Id: loadimages.cc,v 1.2 2000/02/20 14:47:52 jrh Exp $";
#endif

#include "wx/wxprec.h"
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers
#ifndef WX_PRECOMP
# include "wx/wx.h"
#endif
#include "wx/listctrl.h"
#include "wx/bitmap.h"
#include "qlt.h"
#ifndef WIN32
# include "pixmaps.h"
#endif

wxImageList *MyFrame::loadimages(wxPanel* panel)
{
    wxImageList* images = new wxImageList(16,16,TRUE);
    
#ifndef WIN32
    wxIcon *icon = new wxIcon(up);
    images->Add(*icon);
    delete icon;
    icon = new wxIcon(folder);
    images->Add(*icon);
    delete icon;
    icon = new wxIcon(doc);
    images->Add(*icon);
    delete icon;
    icon = new wxIcon(exe);
    images->Add(*icon);
    delete icon;
    btn[0] = new wxBitmapButton(panel,ID_BUTTON_LEFT, left_xpm);    
    btn[1] = new wxBitmapButton(panel, ID_BUTTON_RIGHT, right_xpm);
#else
    wxIcon *icon = new wxIcon("up", wxBITMAP_TYPE_ICO_RESOURCE);
    images->Add(*icon);
    delete icon;
    icon = new wxIcon("folder", wxBITMAP_TYPE_ICO_RESOURCE);
    images->Add(*icon);
    delete icon;
    icon = new wxIcon("file", wxBITMAP_TYPE_ICO_RESOURCE);
    images->Add(*icon);
    delete icon;
    icon = new wxIcon("exe", wxBITMAP_TYPE_ICO_RESOURCE);
    images->Add(*icon);
    delete icon;
    SetIcon(wxIcon("ql_icon"));
    wxBitmap bm0 = wxBitmap("iconL", wxBITMAP_TYPE_RESOURCE);
    btn[0] = new wxBitmapButton(panel,ID_BUTTON_LEFT, bm0);
    wxBitmap bm1 = wxBitmap("iconR", wxBITMAP_TYPE_RESOURCE);
    btn[1] = new wxBitmapButton(panel,ID_BUTTON_RIGHT, bm1);
#endif
    return images;
}

