//////////////////////////////////////////////////////////////
// ntvfs.cc
//
//
// Copyright (C) 1999 Jonathan R. Hudson
// Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//   $Log: ntvfs.cc,v $
//   Revision 1.2  2000/02/20 14:47:52  jrh
//   Windows root fixes
//
//   Revision 1.1  1999/11/09 20:13:15  jrh
//   Initial revision
//
//
//////////////////////////////////////////////////////////////
#ifdef _GNUC_
static char rcsid[] __attribute__ ((unused)) ="$Id: ntvfs.cc,v 1.2 2000/02/20 14:47:52 jrh Exp $";
#endif
#include "vfs.h"

nativefs::nativefs(string dir=0) : vfs()
{
    isnative = 1;
    setcwd(dir);
}

void nativefs::setcwd(string& dir)
{
    char buf[PATH_MAX];
    chdir(dir.c_str());
    cwd = getcwd(buf, sizeof(buf));
}

int nativefs::readdir(string dir)
{
    DIR *d = NULL;
    int m;

    setcwd(dir);

    stat = cwd;
    fl.clear();
   
    if (NULL != (d = opendir(".")))
    {
        struct dirent *de;

        for(m = 0; NULL != (de = ::readdir(d)); m++)
        {
            struct stat st;
            int ok = 0;
#ifndef WIN32
            char *lp, pnam[PATH_MAX];

            if(
                *de->d_name == '.' &&
                   *(de->d_name+1) != 0 && strcmp(de->d_name, "..") != 0)
            {
                continue;
            }
#endif       
            ok = ::stat(de->d_name, &st);
#ifndef WIN32
            for(lp = de->d_name; (ok == 0 && S_ISLNK(st.st_mode));)
            {
                int n = readlink(lp, pnam, sizeof(pnam));
                if(n != -1)
                {
                    *(pnam+n) = 0;
                    ok = LSTAT(pnam, &st);
                    lp = pnam;
                }
                else ok = -1;
            }
#else
            if(m == 0 && *de->d_name != '.' && *(de->d_name+1) != 0)
            {
                ok = 0;
                FITEM fi;
                fi.name = ".";
                fi.size = 0;
                fi.time = -1;
                fi.mode = S_IFDIR;
                fl.push_back(fi);
            }
#endif
	   if(ok == 0)
           {
               FITEM fi;
               fi.name = de->d_name;
               fi.size = st.st_size;
               fi.time = st.st_mtime;
               fi.mode = st.st_mode;
               fl.push_back(fi);
           }
        }
        
      closedir(d);
    }
#ifndef __WIN32__
    sort(fl.begin(),fl.end(),cmp_fn());
#else
    sort(fl.begin(),fl.end(),cmp_nocase_fn());
#endif
    return 0;
}

