/*************************************************************
 * optdlg.h
 *
 *
 * Copyright (C) 1999 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   $Log: optdlg.h,v $
 *   Revision 1.1  1999/11/09 20:13:15  jrh
 *   Initial revision
 *
 *
 *************************************************************/

#include <wx/wx.h>
#include <wx/dialog.h>

class OptDlg: public wxDialog
{
  public:
    OptDlg(wxWindow*, const wxString &);
    virtual ~OptDlg();
    int WrapUp(void);
  private:
    void OnClose(wxCommandEvent& event);
    void OnOK(wxCommandEvent& event);    
    void OnCancel(wxCommandEvent& event);
    void OptFileDlg(wxCommandEvent& event);
    void OptFontDlg(wxCommandEvent& event);    
    void OnRb(wxCommandEvent& event);    
    void MakeFontLab(void);
    wxCheckBox *rb[6];
    wxTextCtrl *t[3];
    wxRadioBox *rbox;
    wxStaticText *fl;
    int lp;
    int rp;
    wxString ltxt;
    wxString rtxt;
    DECLARE_EVENT_TABLE()
};


#define LSELCHG 1
#define LTXTCHG 2
#define RSELCHG 4
#define RTXTCHG 8

#define LCHANGE (LSELCHG|LTXTCHG)
#define RCHANGE (RSELCHG|RTXTCHG)
