//////////////////////////////////////////////////////////////
// options.cc
//
//
// Copyright (C) 1999 Jonathan R. Hudson
// Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//   $Log: options.cc,v $
//   Revision 1.3  2000/03/16 22:39:21  jrh
//   Updated window positioning
//
//   Revision 1.2  2000/02/20 14:47:52  jrh
//   Windows root fixes
//
//   Revision 1.1  1999/11/09 20:13:15  jrh
//   Initial revision
//
//
//////////////////////////////////////////////////////////////
#ifdef _GNUC_
static char rcsid[] __attribute__ ((unused)) ="$Id: options.cc,v 1.3 2000/03/16 22:39:21 jrh Exp $";
#endif

#include "wx/wxprec.h"
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers
#ifndef WX_PRECOMP
# include "wx/wx.h"
#endif
#include <wx/app.h>
#include <wx/dialog.h>
#include <wx/string.h>
#include <wx/fontdlg.h>

#ifndef WX20
#include <wx/statline.h>
#endif
#include "qlt.h"
#include "optdlg.h"

#define BUT1 110
#define BUT2 111
#define BUT3 112
#define RB_VAL 113

BEGIN_EVENT_TABLE(OptDlg, wxDialog)
    EVT_BUTTON(BUT1, OptDlg::OptFileDlg)
    EVT_BUTTON(BUT2, OptDlg::OptFileDlg)
    EVT_BUTTON(BUT3, OptDlg::OptFontDlg)
    EVT_BUTTON(wxID_OK, OptDlg::OnOK)
    EVT_BUTTON(wxID_CANCEL, OptDlg::OnCancel)
    EVT_CHECKBOX(RB_VAL, OptDlg::OnRb) 
    EVT_CHECKBOX(RB_VAL+1, OptDlg::OnRb) 
    EVT_CHECKBOX(RB_VAL+2, OptDlg::OnRb) 
    EVT_CHECKBOX(RB_VAL+3, OptDlg::OnRb) 
    EVT_CHECKBOX(RB_VAL+4, OptDlg::OnRb) 
    EVT_CHECKBOX(RB_VAL+5, OptDlg::OnRb) 
END_EVENT_TABLE()

DECLARE_APP(MyApp) 

OptDlg::~OptDlg()
{
}

#ifndef WIN32
# define WID (460)
# define HGT (140+80)
#else
# define WID (480)
# define HGT (160+90)
#endif

OptDlg::OptDlg(wxWindow *parent,const wxString &title ) 
        : wxDialog (parent, -1, title, wxDefaultPosition, wxSize(WID,HGT))

{

    const wxString choices[] = {
        "Read Only",
        "Read/Write"
    };

    lp = wxGetApp().GetLsel();
    rp = wxGetApp().GetRsel();    

    SetAutoLayout(TRUE);
    wxPanel *panel = new wxPanel(this);
     
    wxStaticText *l1 = new wxStaticText(panel, -1, "Native Directory ");
    wxStaticText *l2 = new wxStaticText(panel, -1, "QL Floppy ");
    wxStaticText *l3 = new wxStaticText(panel, -1, "QXL Disk File ");
    wxButton *b[2];
    
    t[0] = new wxTextCtrl(panel, -1,
                          wxGetApp().GetNdsk(),
                          wxPoint(-1, -1), 
                          wxSize(200,-1));
    t[1]= new wxTextCtrl(panel, -1, 
                         wxGetApp().GetQflp(), 
                         wxPoint(-1, -1), 
                         wxSize(200,-1));
    t[2] = new wxTextCtrl(panel, -1, 
                          wxGetApp().GetQdsk(), 
                          wxPoint(-1, -1), 
                          wxSize(200,-1));

    b[0] = new wxButton(panel, BUT1, "Browse ...");
    b[1] = new wxButton(panel, BUT2, "Browse ...");     

    int n = 0;
    
    rb[n] = new wxCheckBox(panel, RB_VAL+n, "", 
                              wxDefaultPosition,
                              wxDefaultSize,
                              wxRB_GROUP);
    n++; rb[n] = new wxCheckBox(panel, RB_VAL+n, "", 
                              wxDefaultPosition,
                              wxDefaultSize,
                              0);
    n++; rb[n] = new wxCheckBox(panel, RB_VAL+n, "", 
                              wxDefaultPosition,
                              wxDefaultSize,
                              0);

    n++; rb[n] = new wxCheckBox(panel, RB_VAL+n,"", 
                              wxDefaultPosition,
                              wxDefaultSize,
                              wxRB_GROUP);
    n++; rb[n] = new wxCheckBox(panel, RB_VAL+n, "", 
                              wxDefaultPosition,
                              wxDefaultSize,
                              0);
    n++; rb[n] = new wxCheckBox(panel, RB_VAL+n, "", 
                              wxDefaultPosition,
                              wxDefaultSize,
                              0);
    
    if(lp != -1)
    {
        ltxt = wxGetApp().GetDevTxt(lp);
        rb[lp]->SetValue(1);
    }
    
    if(rp != -1)
    {
        rtxt = wxGetApp().GetDevTxt(rp);
        rb[rp+3]->SetValue(1);
    }

    rbox = new wxRadioBox(panel, -1, "QXL I/O mode",  
                          wxDefaultPosition,
                          wxDefaultSize,
                          2,choices, 0,
#ifndef WIN32
                          wxRA_SPECIFY_COLS
#else
                          wxRA_SPECIFY_ROWS
#endif
                          );


    rbox->SetSelection(wxGetApp().GetQXLMode());
    
    fl = new wxStaticText(panel, -1, "",
                          wxDefaultPosition,
                          wxDefaultSize);
    MakeFontLab();    

    wxButton *bfont = new wxButton(panel, BUT3, "Fixed Font ...",
                                   wxDefaultPosition,
                                   wxDefaultSize);

    wxButton *but1  = new wxButton(panel, wxID_OK, "OK",
                                   wxDefaultPosition,
                                   wxDefaultSize);
    
    wxButton *but2  = new wxButton(panel, wxID_CANCEL, "Cancel",
                                   wxDefaultPosition,
                                   wxDefaultSize);
    
    wxLayoutConstraints *c = new wxLayoutConstraints;

    c->left.SameAs (l1, wxRight, 5);
    c->top.SameAs (panel, wxTop, 5);
    c->width.AsIs() ;
    c->height.AsIs();
    t[0]->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (l2, wxRight, 5);
    c->top.SameAs (t[0], wxBottom, 5);
    c->width.AsIs() ;
    c->height.AsIs();
    t[1]->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (l3, wxRight, 5);
    c->top.SameAs (t[1], wxBottom, 5);
    c->width.AsIs() ;
    c->height.AsIs();
    t[2]->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 5);
    c->centreY.SameAs (t[0], wxCentreY);
    c->width.AsIs() ;
    c->height.AsIs();
    l1->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 5);
    c->centreY.SameAs (t[1], wxCentreY);
    c->right.SameAs(l1, wxRight) ;
    c->height.AsIs();
    l2->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 5);
    c->centreY.SameAs (t[2], wxCentreY);
    c->right.SameAs(l1, wxRight) ;
    c->height.AsIs();
    l3->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (t[0], wxRight, 5);
    c->centreY.SameAs (t[0], wxCentreY);
    c->width.AsIs() ;
    c->height.AsIs();
    b[0]->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (t[2], wxRight, 5);
    c->centreY.SameAs (t[2], wxCentreY);
    c->width.AsIs() ;
    c->height.AsIs();
    b[1]->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (b[0], wxRight, 5);
    c->centreY.SameAs (t[0], wxCentreY);
    c->width.AsIs() ;
    c->height.AsIs();
    rb[0]->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (b[0], wxRight, 5);
    c->centreY.SameAs (t[1], wxCentreY);
    c->width.AsIs() ;
    c->height.AsIs();
    rb[1]->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (b[0], wxRight, 5);
    c->centreY.SameAs (t[2], wxCentreY);
    c->width.AsIs() ;
    c->height.AsIs();
    rb[2]->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (rb[0], wxRight, 5);
    c->centreY.SameAs (t[0], wxCentreY);
    c->width.AsIs() ;
    c->height.AsIs();
    rb[3]->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (rb[3], wxLeft, 0);
    c->centreY.SameAs (t[1], wxCentreY);
    c->width.AsIs() ;
    c->height.AsIs();
    rb[4]->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (rb[3], wxLeft, 0);
    c->centreY.SameAs (t[2], wxCentreY);
    c->width.AsIs() ;
    c->height.AsIs();
    rb[5]->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 20);
    c->top.SameAs (t[2], wxBottom, 10);
    c->height.AsIs();
    c->width.AsIs();
    rbox->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->right.SameAs (panel, wxRight, 10);
    c->top.SameAs (rbox, wxTop);
    c->height.AsIs();
    c->width.AsIs();
    bfont->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (rbox, wxRight, 10);
    c->right.SameAs (panel, wxRight, 10);
    c->top.SameAs (bfont, wxBottom, 2);
    c->height.AsIs();
    fl->SetConstraints(c);

#ifndef WX20    
    wxStaticLine *ln = new wxStaticLine(panel, -1, 
                                        wxDefaultPosition, wxSize(3,3),
                                        wxHORIZONTAL);

    c = new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 10);
    c->right.SameAs (panel, wxRight, 10);
    c->top.SameAs (rbox, wxBottom, 5);
    c->height.AsIs();
    ln->SetConstraints(c);
#endif
    c =  new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 20);
    c->bottom.SameAs (panel, wxBottom, 5);
    c->width.AsIs() ;
    c->height.AsIs();
    but1->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->right.SameAs (panel, wxRight, 20);
    c->bottom.SameAs (panel, wxBottom, 5);
    c->width.AsIs() ;
    c->height.AsIs();
    but2->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs       (this, wxLeft);
    c->top.SameAs        (this, wxTop);
    c->right.SameAs (this, wxRight);
    c->height.SameAs (this, wxBottom);
    panel->SetConstraints(c);
    Layout();
} 

void OptDlg::OnClose (wxCommandEvent& WXUNUSED(event) )
{
    Close();
}

void OptDlg::MakeFontLab(void)
{
    if(fl)
    {
        wxString lbl;
        if (wxGetApp().GetFixFont().GetFaceName().size())
            lbl = wxGetApp().GetFixFont().GetFaceName();
        else
            lbl = "Default";
        lbl << "-" << wxGetApp().GetFixFont().GetPointSize();        
        fl->SetFont(wxGetApp().GetFixFont());
        fl->SetLabel(lbl);
    }
}

void OptDlg::OnOK(wxCommandEvent& event )
{
    short i;
    
    wxGetApp().SetLsel(-1);
    wxGetApp().SetRsel(-1);

    for(short i = 0; i < 3; i++)
    {
        if(rb[i]->GetValue())
        {
            wxGetApp().SetLsel(i);
            break;
        }
    }
    for(i = 0; i < 3; i++)
    {
        if(rb[i+3]->GetValue())
        {
            wxGetApp().SetRsel(i);
            break;
        }
    }

    wxGetApp().SetQXLMode(rbox->GetSelection());
    wxGetApp().SetNdsk(t[0]->GetValue());
    wxGetApp().SetQflp(t[1]->GetValue());
    wxGetApp().SetQdsk(t[2]->GetValue());          
    EndModal(wxID_OK);
}

int OptDlg::WrapUp(void)
{
    int res = 0;
    if(lp != wxGetApp().GetLsel())
    {
        res |= LSELCHG;
    }
    
    if((lp = wxGetApp().GetLsel()) != -1)
    {
        if(ltxt != wxGetApp().GetDevTxt(lp))
        {
            res |= LTXTCHG;
        }
        
    }

    if(rp != wxGetApp().GetRsel())
    {
        res |= RSELCHG;
    }

    if((rp = wxGetApp().GetRsel()) != -1)
    {
        if(rtxt != wxGetApp().GetDevTxt(rp))
        {
            res |= RTXTCHG;
        }
    }

    return res;
}

void OptDlg::OnCancel(wxCommandEvent& event )
{
    EndModal(wxID_CANCEL);
}

void OptDlg::OptFontDlg(wxCommandEvent& event )
{
    wxFontData fdx;

    fdx.SetInitialFont((wxGetApp().GetFixFont()));
    
    wxFontDialog f(this, &fdx);

    if(wxID_OK == f.ShowModal())
    {
        fdx = f.GetFontData();
        wxFont fnt(fdx.GetChosenFont());
        wxGetApp().SetFixFont(fnt);
        MakeFontLab();
    }
}

void OptDlg::OptFileDlg(wxCommandEvent& event )
{
    int res;
    wxString dir;
    int id = event.GetId();    
    int idx = (id == BUT1) ? 0 : 2;
    size_t n;
    n = t[idx]->GetValue().rfind('/');
    dir = t[idx]->GetValue().substr(0,n);

    wxFileDialog* df = new wxFileDialog(this, "Choose a file/device",dir);

    if((res = df->ShowModal()) == wxID_OK)
    {
        t[idx]->SetValue(df->GetPath());
    }
    df->Destroy();
}

void OptDlg::OnRb(wxCommandEvent& event )
{
    wxCheckBox *b =  reinterpret_cast<wxCheckBox*>(event.GetEventObject());

    int i = event.GetId() - RB_VAL;
    int j = (i+3) % 6;
    if(b->GetValue())
    {
        int m = 3*(i / 3);
        for(int k = 0; k < 3; k++, m++)
        {
            rb[m]->SetValue(m == i);
        }
	if(rb[j]->GetValue())
	{
	    rb[j]->SetValue(0);
	}
    }
}

