/*************************************************************
 * qdisk.h
 *
 *
 * Copyright (C) 1999 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   $Log: qdisk.h,v $
 *   Revision 1.1  1999/11/09 20:13:15  jrh
 *   Initial revision
 *
 *
 *************************************************************/

#ifndef _qdisk_h_
#define _qdisk_h_

#include <map>
#include <fstream>
#include <string>

#include <vdk/vdk.h>
#include <vdk/FileDialog.h>

#include "vfs.h"

class vList: public VDKCustomList
{
  public:
    vList(VDKForm* owner, int n, char **titles,
          GtkSelectionMode m=(GtkSelectionMode)0):
        VDKCustomList(owner,n, titles, m) {}
    virtual ~vList() {}
    vfs *fs;
    short fstype;
    void createVFS(short);
    void loadVFS();
    bool isdouble;
    short id;
  protected:
    bool  MouseClick(VDKObject* sender, GdkEvent* event);
    guint32 ltime;
    DECLARE_EVENT_LIST(vList);
};

class vApp: public VDKApplication
{
  protected:
    bool  showh;
    short rsel,lsel;
    map <string,string>prefs;
    void ReadPrefs();
  public:
    static vApp *me;
    vApp(int* argc, char** argv);
    ~vApp();
    void Setup(void);
    void WrapUp(void);
    inline short GetLsel() {return lsel;}
    inline short GetRsel() {return rsel;}
    inline void SetLsel(short i) {lsel=i;}
    inline void SetRsel(short i) {rsel=i;}
    inline bool GetShowh() {return showh;}
    inline void SetShowh(bool i) {showh=i;}
    inline const char* GetNdsk() {return prefs["root"].c_str();}
    inline const char* GetQflp() {return prefs["ql floppy"].c_str();}
    inline const char* GetQdsk() {return prefs["ql disk"].c_str();}    
    inline void SetNdsk(char* s) {prefs["root"]=s;}
    inline void SetQflp(char* s) {prefs["ql floppy"]=s;}        
    inline void SetQdsk(char* s) {prefs["ql disk"]=s;}        
    inline const char * GetDevTxt(short i)
    {
        return (i == 0) ? GetNdsk() : (i == 1) ? GetQflp() : GetQdsk();
    }
    
};


class vForm: public VDKForm
{
 
  protected:
    VDKMenuItem *opt_menu, *quit_menu,*hpmenu;
    vList*  customlist0;
    vList*  customlist1;
    VDKStatusbar*  statusbar1;
    VDKStatusbar*  statusbar2;    
    VDKCustomButton *lbut;
    VDKCustomButton *rbut;    
    VDKMenuItem *popDel, *popFmt, *popInf, *popMkd, *popVer, *popVue;
    bool vButton(VDKObject *);
    
public:
    vForm(VDKApplication* app, char* title);
    ~vForm();
    void Setup(void);
    vList *clist[2];
    VDKStatusbar* stb[2];
    vList* lpop;
    VDKMenu *popmenu;
    VDKMenuItem *popi[6];

    bool Options(VDKObject *);
    bool vPopDel(VDKObject *);
    bool vPopFmt(VDKObject *);
    bool vPopInf(VDKObject *);
    bool vPopMkd(VDKObject *);
    bool vPopVer(VDKObject *);
    bool vPopVue(VDKObject *);    
    bool vQuit(VDKObject *);
    DECLARE_SIGNAL_MAP(vForm);
};


#endif
