//////////////////////////////////////////////////////////////
// qlflp.cc
//
//
// Copyright (C) 1999 Jonathan R. Hudson
// Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//   $Log: qlflp.cc,v $
//   Revision 1.3  2000/02/20 14:47:52  jrh
//   Windows root fixes
//
//   Revision 1.2  2000/01/28 21:39:21  jrh
//   Updated for Win32 no exceptions fix
//
//   Revision 1.1  1999/11/09 20:13:15  jrh
//   Initial revision
//
//
//////////////////////////////////////////////////////////////
#ifdef _GNUC_
static char rcsid[] __attribute__ ((unused)) ="$Id: qlflp.cc,v 1.3 2000/02/20 14:47:52 jrh Exp $";
#endif
//////////////////////////////////////////////////////////////

#include "qlt.h"
#include "vfs.h"
#include "fmtdlg.h"

#include <stack>

DECLARE_APP(MyApp) 

typedef struct
{
    string lastdir;
    string fsdir;
} selm;
        

bool qlflpfs::CheckVers()
{
    string::size_type n;
    string z("(version ");
    int vers = 0;
    char *p;
    
    n = version.find(z);
    n += z.size();
    
    vers = strtol(version.substr(n,string::npos).c_str(),&p, 10);
    if(p)
    {
        p++;
        vers = vers * 100 + strtol(p, NULL, 10);
    }

    return vers < min_version();
}

qlflpfs::qlflpfs(string dev) : qdosfs()
{
    PFILE *fp = 0;
    bool res = false;
    char *p,buf[80];
    PRETVAR;

    isnative = 0;
    pd = 0;
    ndev = dev;

    cwd.erase();
    qdir.erase();
    
    if(0 != (fp = POPEN(QLTOOLS " -v", "r", &ep)))
    {
        res = (PGETS(buf, 80, fp) != NULL);
        if(0 != (p = strchr(buf,'\n')))
        {
            *p  = 0;
        }
        version = buf;        
        PCLOSE(fp);

        if(0 != (res = CheckVers()))
        {
            wxString msg("qltools version mismatch\n"
                         "Minimum required version is ");
            int n = min_version();
            msg << n / 100 << "." << n % 100; 
            wxMessageBox(msg, "Problem!", wxOK | wxICON_EXCLAMATION);
        }
    }
    else
    {
        wxString msg("Error running qltools\n");
        msg = msg  + strerror(errno);
        wxMessageBox(msg, "Problem!", wxOK | wxICON_EXCLAMATION);
        res = true;
    }
    fl.reserve(128);
    verror = (res) ? -1 : 0;
}

void qlflpfs::setcwd(string& dir)
{
    cwd.erase();
}

string qlflpfs::fname(int n)
{
    string r("");
    
    if(qdir.size())
    {
        r = qdir+'_'+fl[n].name;
    }
    else
    {
        r = fl[n].name;
    }
    return r;
}


int qlflpfs::readdir(string dir)
{
    string cmd("");
    string dirnam("");
    string lastdir("");
    string tbuf("");
    FITEM fi;    
    PFILE *fp;
    char buf[1024];
    
    cmd = QLTOOLS " " + ndev + " -d";

    if(dir == "..")
    {
        string::size_type n;
        n = cwd.find_last_of("/");
        
        if(n == string::npos)
        {
            cwd.erase();
        }
        else
        {
            cwd.erase(n,cwd.size());
        }
    }
    else if(dir == "/")
    {
        cwd.erase();
    }
    else if(dir != ".")
    {
        if(cwd.size())
        {
            cwd += "/";
        }
        cwd += dir;
    }
    
    string::size_type n;
    qdir = cwd;

    while((n = qdir.find('/')) != string::npos)
    {
        qdir.replace(n,1,"_");
    }

    fl.clear();

    fi.name = ".";
    fi.mode = S_IFDIR;
    fi.size = 0;
    fi.time = -1;
    fl.push_back(fi);
    fi.name = "..";
    fi.mode = S_IFDIR;
    fi.size = 0;
    fi.time = -1;
    fl.push_back(fi);

    if((fp = POPEN(const_cast<char*>(cmd.c_str()), "r", NULL)) != NULL)
    {
        for (int i = 0; PGETS(buf, sizeof(buf), fp); i++)
        {
            int mode;
            string name,size,date;

            mode = 0;
            string s(buf);

            string::size_type n = s.find("\n");
            if(n != string::npos)
            {
                s.erase(n);
            }
        
            switch(i)
            {
                case 0:
                    tbuf = buf;
                    break;
                case 1:
                    tbuf = tbuf + " " + buf;
                    break;
                case 2:
                    break;
                    
                default:
                    name = s.substr(0,36);

                    string::size_type n = name.find_last_not_of(" ");
                    if(n != string::npos)
                    {
                        name.erase(n+1);
                    }

                    if(s.substr(36,1) == "(")
                    {
                        mode = S_IFDIR;
                        date = "";
                        size = s.substr(42,8);
                    }
                    else
                    {
                        if(s.substr(36,1) == "E")
                        {
                            mode = S_IXUSR|S_IFREG;
                        }
                        else
                        {
                            mode = S_IFREG;
                        }
                        size = s.substr(37,8);
                        date = s.substr(46,17);
                    }
                    break;
            }
            if(i > 2)
            {
                int wanted = 0;

                if(qdir.size())
                {
                    if(name.find(qdir+'_') == 0)
                    {
                        wanted  = 1;
                    }
                    else wanted = 0;
                }
                else 
                    wanted = 1;

                if(wanted)
                {
                    if(lastdir == qdir || name.find(lastdir+'_') != 0)
                    {
                        int n;
                        
                        if(0 != (n = qdir.size()))
                        {
                            fi.name = name.substr(n+1, string::npos);
                        }
                        else
                            fi.name = name;
                        fi.size = atoi(size.c_str());
                        if(date.size())
                        { 
                            struct tm tm;
                            char c;
                            istrstream ist(date.c_str());
                            memset(&tm, 0, sizeof(tm));
                            
                            ist >> tm.tm_mday >> c >> tm.tm_mon >> c 
                                >> tm.tm_year >> tm.tm_hour >> c 
                                >> tm.tm_min >> c >> tm.tm_sec;
                            tm.tm_mon--;
                            if( tm.tm_year < 60)
                            {
                                tm.tm_year += 100;
                            }
                    
                            fi.time = mktime(&tm);
                        }
                        else
                        {
                            fi.time =-1;
                        }
                        fi.mode = mode;
                        fl.push_back(fi);
                    }
                }
                if(mode == S_IFDIR)
                {
                    lastdir = name;
                }
            }
        }

        PCLOSE(fp);
        sort(fl.begin(),fl.end(),cmp_nocase_fn());
        stat = tbuf + "  : " +  ndev+ "/" + qdir;
    }
    else
    {
        string msg;

        msg = "Error getting directory for " + ndev +"\n" + strerror(errno);
        wxMessageBox(msg.c_str(), "Problem!", wxOK | wxICON_EXCLAMATION);
    }
    return 0;
}

int qlflpfs::in(vfs*f, vector<int>& arry)
{
    verror = 0;

    pd  = new BusyBox(wxGetApp().GetTopWindow(),
                      "Working..", "Copying:", verror);
    pd->Show(TRUE);
    pd->SetBusy();

    for(unsigned int i = 0; verror == 0 && i < arry.size(); i++)
    {
        string of = f->fl[arry[i]].name;
        if(S_ISDIR(f->fl[arry[i]].mode))
        {
            nrecurse(of);
        }
        else
        {
            in(of);
        }
    }    
    pd->Close();
    pd = 0;
    if(verror)
    {
        ShowError();
        errnam.erase();
        verror = 0;
    }
    
    return 0;
}

int qlflpfs::in(string& d)
{
    string qf;
    size_t spos;
    
    if(qdir.size())
    {
        qf = qdir + '_' + d;
    }
    else
    {
        qf = d;
    }

    while((spos = qf.find('/')) != string::npos)
    {
        qf.replace(spos,1,"_");
    }
    while((spos = qf.find('.')) != string::npos)
    {
        qf.replace(spos,1,"_");
    }

    if(pd) pd->SetText(const_cast<char*>(qf.c_str()));
    if(qf.size() > 36)
    {
        verror = ENAMETOOLONG;
    }
    else
    {
        string cmd ; 
        cmd = QLTOOLS " " + ndev + " -W " + d + "=" + qf;
        
        verror = SYSTEM(const_cast<char*>(cmd.c_str()), 0);        
    }
    if(verror)
        errnam = qf;
    return 0;
}


int qlflpfs::out(vector<int>& arry,vfs* ofs)
{                
    int recur = 0;
    string nf;
    string f;
    char *cwd = 0;
    char *newd = 0;
    string lastdir;
    string fsdir("");

    int maxn = arry.size();
    vector<bool>b(maxn);
    
    verror = 0;

    if(ofs)
    {
        settmpdir(&cwd, &newd);
    }
    pd  = new BusyBox(wxGetApp().GetTopWindow(),
                      "Working..", "Copying:", verror);
    pd->Show(TRUE);
    pd->SetBusy();

    for(int i = 0; verror == 0 && i < maxn; i++)
    {
        if(((fl[arry[i]].mode &  S_IFDIR) == 0) || (fl[arry[i]].size == 0))
        {
            f = fname(arry[i]);
            pd->SetText(const_cast<char*>(f.c_str()));
            nf = cvtname(f,fsdir);
            out(nf, f);
            if(ofs)
            {
                ofs->in(nf);
                ::unlink(const_cast<char*>(nf.c_str()));
            }
            b[i]=1;
        }
        else
        {
            b[i]=0;
            if(fl[arry[i]].name != "." && 
               fl[arry[i]].name != "..")
                recur++;
        }
    }

    /*
     This is singularly inefficent, but with modern (intel) CPUs,
     who cares!
    */

    if(recur)
    {
            /* Fortunately, the native FS is cd'ed to the other panel,
               which conveniently covers up all the deficiencies in our
               vfs object model
            */
        vector<FITEM>::iterator q;
        
        vector<FITEM> all;
        ParseWholeDisk(all);
       
        stack<selm> stk;
        
        for(unsigned int i = 0; verror == 0 && i < arry.size(); i++)
        {
            if(b[i] == 0)
            {
                f = fname(arry[i]);
                for(q = all.begin(); verror == 0 && q != all.end(); q++)
                {
                    if(q->mode != -1)
                    {
                        if(cmp_nocase(f, q->name.substr(0,f.size()))== 0)
                        {
                            selm e;
                            
                            while(!stk.empty())
                            {
                                e = stk.top();
                                if(0 != q->name.find(e.lastdir))
                                {
                                    stk.pop();
                                }
                                else
                                    break;
                            }
                            
                            if(stk.empty())
                            {
                                lastdir.erase();
                                fsdir.erase();
                            }
                            else
                            {
                                lastdir = e.lastdir;
                                fsdir = e.fsdir;
                            }
                       
                            string t;
                            t = q->name.substr(lastdir.size(), string::npos);
                            if(q->mode)
                            {
                                fsdir = fsdir + t + '/';
                                MKDIR(const_cast<char *>(fsdir.c_str())
                                        ,0755);
                                lastdir = q->name + '_';
                                selm e1;
                                e1.lastdir = lastdir;
                                e1.fsdir = fsdir;
                                stk.push(e1);
                                if(ofs) ofs->mkdir(q->name);
                            }
                            else
                            {
                                nf = cvtname(t, fsdir);
                                pd->SetText(const_cast<char*>(q->name.c_str()));
                                out(nf, q->name);
                                if(ofs)
                                {
                                    ofs->in(nf);
                                    unlink(const_cast<char*>(nf.c_str()));
                                }
                            }
                            q->mode = -1;
                        }
                    }
                }
            }
        }
    }
    if(ofs)
    {
        resettmpdir(cwd, newd);
    }

    pd->Close();
    pd = 0;
    if(verror)
    {
        ShowError();
        errnam.erase();
        verror = 0;
    }

    return 0;
}


int qlflpfs::out(string& d,string& s)
{
    string cmd;
    string qlp;
    cmd = QLTOOLS " "  + ndev + " " + s;
    PipetoFile(cmd, d);
    return 0;
}

int qlflpfs::mkdir(string& d, int mode=0755)
 {
     string r;
     
     if(qdir.size())
     {
         r = qdir+'_'+d;
     }
     else
     {
         r = d;
     }
     if(r.size() && r.size() < 37)
     {
         string cmd = QLTOOLS " " + ndev + " -M " + r; 
         verror = SYSTEM(const_cast<char*>(cmd.c_str()), 0);
     }
     else
         verror = ENAMETOOLONG;
     if(verror)
         errnam = r;
     return 0; 
}

int qlflpfs::rm(string& d)
{
    string cmd = QLTOOLS " " + ndev + " -r " + d; 
    verror = SYSTEM(const_cast<char*>(cmd.c_str()), NULL);
    if(verror)
        errnam = d;
    return 0; 
}

void qlflpfs::ParseWholeDisk(vector<FITEM>& all)
{
    string cmd;
    string name;
    string lastdir = "";
    
    PFILE *fp;
    
    cmd = QLTOOLS " " + ndev + " -d";

    if((fp = POPEN(const_cast<char*>(cmd.c_str()), "r", NULL)) != NULL)
    {
        char buf[256];
        
        for (int i = 0; PGETS(buf, 256, fp); i++)
        {
            char *nl;
            int mode=0;
            string s,name;
            FITEM fi;
            
            if(0 != (nl = strchr(buf, '\n')))
            {
                *nl = 0;
            }

            s = buf;
            switch(i)
            {
                case 0:
                case 1:
                case 2:
                    break;
                    
                default:
                    name = s.substr(0,36);

                    size_t n = name.find_last_not_of(' ');

                    if(n != string::npos)
                    {
                        name.erase(n+1,name.size());
                    }

                    if(s.substr(36,1) == "(")
                    {
                        mode = S_IFDIR;
                    }
                    else
                        mode = 0;
                    break;
            }
            fi.mode = mode;
            fi.name = name;
            all.push_back(fi);
        }
        PCLOSE(fp);
//        sort(all.begin(),all.end(),cmp_nocase_fn());
    }
    else
    {
        verror = errno;
        errnam = ndev;
    }
    
}

int qlflpfs::rm(vector<int>& arry)
{

    int recur = 0;
    verror = 0;
    int maxn = arry.size();
    vector<bool>b(maxn);

    pd  = new BusyBox(wxGetApp().GetTopWindow(),
                      "Working..", "Deleting", verror);
    pd->Show(TRUE);
    pd->SetBusy();

    for(int i = 0; i < maxn; i++)
    {
        if((fl[arry[i]].mode &  S_IFDIR) == 0)
        {
            string f = fname(arry[i]);
            pd->SetText(const_cast<char*>(f.c_str()));
            rm(f);
            b[i]=1;
        }
        else 
        {
            b[i] = 0;
            if(fl[arry[i]].name != "." && 
               fl[arry[i]].name != "..")
                recur++;
        }
    }
    
    /*
     by working from the back up, we ensure all directories are
     empty before deletion.

     This is singularly inefficent, but with modern (intel) CPUs,
     who cares!
    */

    if(recur)
    {
        vector<FITEM> all;
        ParseWholeDisk(all);

        for(unsigned int i = 0; verror == 0 && i < arry.size(); i++)
        {
            if(b[i] == 0)
            {
                string fnam;
                fnam = fname(arry[i]);
                    // Borland barfs on reverse iterators alas
                vector<FITEM>::iterator q;
                for(q = all.end(); verror == 0 && q != all.begin(); q--)
                {
                    if(q->mode != -1)
                    {
                        if(cmp_nocase(fnam, q->name.substr(0,fnam.size()))== 0)
                        {
                            pd->SetText(const_cast<char*>(q->name.c_str()));
                            rm(q->name);
                            q->mode = -1;
                        }
                    }
                }
            }
        }
    }
    pd->Close();
    pd = 0;

    if(verror)
    {
        ShowError();
        errnam.erase();
        verror = 0;
    }
    return 0;
}

void qlflpfs::PipetoFile(string &cmd, string& file)
{
    PFILE *fp = 0;
    char buf[512];
    int n;
    PRETVAR;

    ofstream f(file.c_str(), ios::out|ios::binary);
    
    if(f)
    {
        if(0 != (fp = POPEN(const_cast<char*>(cmd.c_str()), "r", &ep)))
        {
            while((n = PREAD(buf, 1, sizeof(buf), fp)) > 0)
            {
                f.write(buf,n);
            }
            PCLOSE(fp);
        }
        else
        {
            verror = errno;
            errnam = cmd;
        }
        f.close();
    }
    else
    {
        verror = errno;
        errnam = file;      
    }
}

void qlflpfs::GetInfo(string& tmp)
{
    string cmd;
    cmd = QLTOOLS " "  + ndev + " -i";
    PipetoFile(cmd, tmp);
}

int qlflpfs::format(wxWindow *f)
{
    char flg=0;
    string s;

    s = ::wxGetTextFromUser("Disk Label: ", "Format Disk");
    if(s.size())
    {
        if(s[10] == '*')
        {
            if(s[11] == 'd' || s[11] == 'D' )
                flg = 'd';
            else if(s[11] == 'h' || s[11] == 'H' )
                flg = 'h';
    }
        else
        {
            int ns = GetFDParams(const_cast<char*>(ndev.c_str()));
            flg = (ns == 1440) ? 'd' : (ns == 2880) ? 'h' : 0;
        }

        if(s.size() > 10)
        {
            s.erase(10, string::npos);
        }
        
        if(flg == 0)
        {
            FmtDlg *d = new FmtDlg (f, "Disk Format");
            int res = d->ShowModal();
            
            if(res == wxID_OK)
            {
                flg = d->Res() ? 'h' : 'd';
            }
            d->Destroy();
        }
        
        if(flg)
        {
            string cmd = QLTOOLS " " + ndev + " -f" + flg + "d \"" + s + "\""; 
            verror = SYSTEM(const_cast<char*>(cmd.c_str()), NULL);
            if(verror)
                errnam = ndev;
        }
    }
    
    return (flg == 0);
}
