/*************************************************************
 * qlflp.h
 *
 *
 * Copyright (C) 1999 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   $Log: qlflp.h,v $
 *   Revision 1.1  1999/11/09 20:13:15  jrh
 *   Initial revision
 *
 *
 *************************************************************/

#ifndef _qlflp_h
#define _qlflp_h

class qlflpfs : public qdosfs
{
  public:
    qlflpfs(string);
    int readdir(string);
    void setcwd(string&);    
    int in(string&);    
    int in(vfs*,vector<int>&);
    int out(string&,string&);    
    int out(vector<int>&,vfs* = 0);
    int format(wxWindow *);
    int mkdir(string&,int n);
    int rm(string&);
    int rm(vector<int>&);
    string fname(int n);
    void GetInfo(string&);
  private:
    void PipetoFile(string&, string&);
    void ParseWholeDisk(vector<FITEM>&);
    bool CheckVers();
    inline int min_version(){return QLTOOLS_MINVERS;}
};

#endif
