//////////////////////////////////////////////////////////////
// qlt.cc
//
//
// Copyright (C) 1999 Jonathan R. Hudson
// Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//   $Log: qlt.cc,v $
//   Revision 1.6  2000/04/05 21:05:34  jrh
//   Help and dll changes
//
//   Revision 1.5  2000/04/02 15:40:20  jrh
//   0.08 changes, cosmetic HCI
//
//   Revision 1.4  2000/03/05 00:03:35  jrh
//   Fixed uninitialised clist->fs
//
//   Revision 1.3  2000/02/20 14:47:52  jrh
//   Windows root fixes
//
//   Revision 1.2  2000/01/28 21:39:21  jrh
//   Updated for Win32 no exceptions fix
//
//   Revision 1.1  1999/11/09 20:13:15  jrh
//   Initial revision
//
//
//////////////////////////////////////////////////////////////
#ifdef __GNUC__
static char rcsid[] __attribute__ ((unused)) ="$Id: qlt.cc,v 1.6 2000/04/05 21:05:34 jrh Exp $";
#endif
/////////////////////////////////////////////////////////////

#include "qlt.h"
#include "vfs.h"
#include "qltmisc.h"
#include "qxlopt.h"
#include "version.h"

#define ICON_UP 0
#define ICON_FOLDER 1
#define ICON_FILE 2
#define ICON_EXE 3

#include "optdlg.h"

#define ID_MENU_QUIT       100
#define ID_MENU_ABOUT      101
#define ID_MENU_PROP       102
#define ID_MENU_FILE       103
#define ID_MENU_VERS       104
#define ID_MENU_QXL        105
#define ID_MENU_HELP       106

#define ID_MENU_DELETE  140
#define ID_MENU_FORMAT  141
#define ID_MENU_INFO    142
#define ID_MENU_MKDIR   143
#define ID_MENU_VIEW    144
#define ID_MENU_VERSION 145

BEGIN_EVENT_TABLE(MyFrame, wxFrame)
    EVT_MENU(ID_MENU_HELP,  MyFrame::Help)
    EVT_MENU(ID_MENU_QUIT,  MyFrame::Quit)
    EVT_MENU(ID_MENU_PROP,  MyFrame::Options)
    EVT_MENU(ID_MENU_ABOUT, MyFrame::About)
    EVT_MENU(ID_MENU_QXL,   MyFrame::NewQxl)
    EVT_BUTTON(ID_BUTTON_LEFT,  MyFrame::OnButtons)
    EVT_BUTTON(ID_BUTTON_RIGHT, MyFrame::OnButtons)
    EVT_MENU_HIGHLIGHT_ALL(MyFrame::OnMenuHighlight) 
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(MyList, wxListCtrl)
#ifndef WIN32
    EVT_RIGHT_UP(MyList::R_Click)
#else
    EVT_RIGHT_DOWN(MyList::R_Click)
#endif
    EVT_LEFT_DCLICK(MyList::LD_Click) 
    EVT_MENU(ID_MENU_DELETE, MyList::vPopDel)
    EVT_MENU(ID_MENU_FORMAT, MyList::vPopFmt)
    EVT_MENU(ID_MENU_INFO, MyList::vPopInf)
    EVT_MENU(ID_MENU_MKDIR, MyList::vPopMkd)
    EVT_MENU(ID_MENU_VIEW, MyList::vPopVue)
    EVT_MENU(ID_MENU_VERSION, MyList::vPopVer)
END_EVENT_TABLE()

IMPLEMENT_APP(MyApp)

//-------------------------------


void MyList::createVFS(short n)
{
    if(fs) delete fs;
    string s;
    s = wxGetApp().GetDevTxt(n);

    switch(n)
    {
        case 0:
            fs = new nativefs(s);
            break;
        case 1:
            fs = new qlflpfs(s);
            break;
        case 2:
            fs = new qxlfs(s);
            break;
    }
    
    if(fs->verror == 0)
    {
        short rwsts = fs->SetRW(wxGetApp().GetQXLMode());
        reinterpret_cast<MyFrame*>(wxGetApp().frame)->btn[id]->Enable(rwsts);
        fs->readdir(".");
        fstype = n;
    }
    else
    {
        if(fs) delete fs;
        fs = 0;
    }
}

void MyList::loadVFS()
{
    time_t  t0,t1,t2;

    t0 = time(NULL);
    t1 = t0 - 3600*24*183;
    t2 = t0 + 3600;
    
    DeleteAllItems();
    
    if(fs)
    {
        unsigned int i;
        wxString p,q;
        wxGetApp().frame->SetStatusText(fs->stat.c_str(), id);
        
        for(i = 0; i < fs->fl.size(); i++)
        {
            int xpm;
            if(fs->fl[i].name == "..")
            {
                xpm = ICON_UP;
            }
            else if(S_ISDIR(fs->fl[i].mode))
            {
                xpm = ICON_FOLDER;
            }
            else if(fs->fl[i].mode & IXPERMS)
            {
                xpm = ICON_EXE;
            }
            else
            {
                xpm = ICON_FILE;
            }

            p.Printf("%8ld", fs->fl[i].size);
            if(fs->fl[i].time != -1)
            {
                struct tm *tm = localtime(&fs->fl[i].time);
                char *fmt;
                int n;
                char x3[80];
                
                if(tm)
                {
                    if(fs->fl[i].time > t1 && fs->fl[i].time < t2)
                    {
                        fmt = "%b %d %H:%M";
                    }
                    else
                    {
                        fmt = "%b %d %Y";
                    }
                    n = strftime(x3, sizeof(x3), fmt, tm);
                }
                q = x3;
            }
            else
            {
                q = "";
            }
            
            InsertItem(i,fs->fl[i].name.c_str(), xpm);
            SetItem(i, 1, p);
            SetItem(i, 2, q);    
        }
    }
}

vector<int> MyList::Selections(void)
{
    int i,j,n;
    n = GetSelectedItemCount();
    vector<int> arry(n);    
    i = 0; j = 0;
    while((j = GetNextItem(j, wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED)) != -1)
    {
        arry[i] = j;
        i++;
    }
    return arry;
}

void MyList::vPopInf(void)
{
    string r;
    vLog *vl;
    
    r = TMPNAM(0);
    fs->GetInfo(r);        
    vl = new vLog(wxGetApp().GetTopWindow(), 
                  "Filesystem Info",r,1);
    vl->ShowModal();
}

inline void MyList::vPopVer(void)
{
    wxMessageBox(fs->fvers(), "Version", wxOK|wxICON_INFORMATION);
}

void MyList::vPopVue(void)
{
    string r;
    string s;

    vector<int> arry;
    arry = Selections();
    
    for(unsigned int i = 0; i < arry.size(); i++)
    {
        if((fs->fl[arry[i]].mode & (S_IXUSR|S_IFREG)) == S_IFREG)
        {
            r = TMPNAM(0);
            s = fs->fname(arry[i]);
            fs->out(r,s);        
            
            vLog *vl = new vLog(this, 
                                const_cast<char *>(s.c_str()),
                                r,1);
            vl->Show(1);
        }
        SetItemState(arry[i], 0, wxLIST_STATE_SELECTED);        
    }
}

void MyList::vPopDel(void) 
{
    vector<int> arry;
    arry = Selections();

    fs->rm(arry);
    fs->readdir(".");
    loadVFS();
}

void MyList::vPopFmt(void) 
{
    fs->format(wxGetApp().GetTopWindow());
    fs->readdir("/");
    loadVFS();
}

void MyList::vPopMkd(void)
{
    wxString s;
    s = wxGetTextFromUser("Directory Name: ",
                          "Make Directory");

    if(s.size())
    {
        string ss;
        ss = s.c_str();
        
        if(fs->mkdir(ss, 0777) == 0)
        {
            fs->readdir(".");
            loadVFS();
        }
    }
}

void MyFrame::NewQxl(void)
{
    int mb = 8;
    wxString xf("/tmp/*.WIN");
    wxString xd("wxqt2 formatted");
    
    QxlDlg *d = new QxlDlg (this, "Disk Format", 
                            xf, xd, mb);
    int res = d->ShowModal();
    d->Destroy();
    if(res == wxID_OK)
    {
        wxString cmd;
         cmd << QXLTOOLSYS << " -W "
             << xf.c_str() << " " << mb << " " << xd.c_str();
         SYSTEM(const_cast<char*>(cmd.c_str()), 0);
    }
}

void MyFrame::Help(wxCommandEvent& WXUNUSED(event))
{
    if(help)
    {
        help->Display("Main page");
    }
    else
    {
        wxMessageBox("You must set the environment variable\n"
                     "WXQT2_HELP_DIR\n"
                     "To access wxqt2 help",
                     "Help", wxOK|wxICON_INFORMATION);
    }
}

void MyFrame::About(wxCommandEvent& WXUNUSED(event))
{
    wxString info =
       "wxqt2 is a graphical front end to Jonathan Hudson's free qxltool and\n"
       "qltools programs\n\n"
       "This program is free software; you can redistribute it and/or modify\n"
       "it under the terms of the GNU General Public License as published by\n"
       "the Free Software Foundation; either version 2 of the License, or\n"
       "(at your option) any later version.\n\n"
       "This program is distributed in the hope that it will be useful,\n"
       "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
       "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
       "GNU General Public License for more details.\n\n"
       "Copyright (C) 1999-2000 Jonathan R. Hudson\n"
       "Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>\n\n";

    info << "wxqt2  v"VERSION" ";

#ifdef __BORLANDC__
    char vers[32];
    sprintf(vers, "%x",__BORLANDC__);
    info << "Win32/Borland C++ " << vers;
#elif defined(__GNUC__)
# ifdef __linux__
    info << "Linux";
# elif defined(__unix__) 
    info << "Unix";
# else    
    info << "Win32";
# endif
    info << "/GNU g++ " << __GNUC__ << "." << __GNUC_MINOR__;
# ifdef __WINNT__
#  ifdef __MINGW32__
    info <<  " (mingw32 " <<  __MINGW32__ << ")";
#  else
    info << " (Cygwin32)";
#  endif
# endif
#else
    info << " Unknown platform";
#endif
    info << " "wxVERSION_STRING" "__DATE__;
    
    wxMessageBox(
        info,
        "About wxqt2",
       wxOK|wxICON_INFORMATION);
}

void MyFrame::OnButtons(wxCommandEvent& event)
{
    int to=-1,from=-1;
    switch (event.GetId())
    {
        case ID_BUTTON_LEFT:
            to = 0;
            from = 1;
            break;
        case ID_BUTTON_RIGHT:
            to = 1;
            from = 0;
            break;
    }
    if(clist[0]->fs && clist[1]->fs)
    {
        vector<int> arry;
        
        arry = clist[from]->Selections();

        if(arry.size())
        {
            if(clist[to]->fs->isNative())
            {
                clist[from]->fs->out(arry);
            }
            else if(clist[from]->fs->isNative())
            {
                clist[to]->fs->in(clist[from]->fs,arry);
            }
            else
            {
                clist[from]->fs->out(arry, clist[to]->fs);
            }
            clist[to]->fs->readdir(".");            
            clist[to]->loadVFS();
            
            for(unsigned int i = 0; i < arry.size(); i++)
            {
                clist[from]->SetItemState(arry[i], 0, wxLIST_STATE_SELECTED);
            }
        }
    }
} 

void MyFrame::InstantiateFS(int cl, int fsn)
{
    clist[cl]->DeleteAllItems();
    if(clist[cl]->fs)
    {
        delete clist[cl]->fs;
        clist[cl]->fs = 0;
    }
    if(fsn != -1)
    {
        clist[cl]->createVFS(fsn);
        if(clist[cl]->fs)
        {
            clist[cl]->fs->readdir(".");            
            clist[cl]->loadVFS();
        }
    }
}

void MyFrame::Options(wxCommandEvent&  WXUNUSED(event))
{
    int n;
    
    OptDlg *o = new OptDlg(this, "Options");
    o->ShowModal();
    n = o->WrapUp();

    if(n & LCHANGE)
    {
        InstantiateFS(0, wxGetApp().GetLsel());
    }

    if(n & RCHANGE)
    {
        InstantiateFS(1, wxGetApp().GetRsel());
    }

    for(int i = 0; i < 2; i++)
    {
        if(clist[i]->fs)
        {
            short rwsts = clist[i]->fs->SetRW(wxGetApp().GetQXLMode());
            btn[i]->Enable(rwsts);
        }
    }
    
    o->Destroy();
}

bool MyFrame::OnClose(void)
{
  Show(FALSE);
  return TRUE;
}

void MyFrame::Setup(int w, int h)
{
    wxPanel *panel;
    wxImageList *images;
    SetAutoLayout(TRUE);

    SetTitle("wxqt2");
    sbar = CreateStatusBar(2);
    SetSize(-1,-1,w, h);
   
    wxMenu *file_menu = new wxMenu("",wxMENU_TEAROFF);
    file_menu->Append(ID_MENU_PROP, "&Options ...\tCtrl-O");
    file_menu->Append(ID_MENU_QXL, "&New QXL File ...\tCtrl-N");
    file_menu->Append(ID_MENU_QUIT, "&Exit\tCtrl-Q");
    wxMenu *help_menu = new wxMenu;
    help_menu->Append(ID_MENU_ABOUT, "&About\tCtrl-A");
    help_menu->Append(ID_MENU_HELP, "&Help\tCtrl-H");
    wxMenuBar *menu_bar = new wxMenuBar;
    menu_bar->Append(file_menu, "&File");
    menu_bar->Append(help_menu, "&Help");

    
    SetMenuBar(menu_bar);
    
    panel = new wxPanel(this);
    panel->SetBackgroundColour(wxColour(192, 192, 192));

    images = loadimages(panel);

    wxLayoutConstraints *b1 = new wxLayoutConstraints;
    b1->centreX.SameAs    (panel, wxCentreX);
    b1->top.PercentOf        (panel, wxHeight, 30);
    b1->width.AsIs() ;
    b1->height.AsIs();
    btn[0]->SetConstraints(b1);
  
    wxLayoutConstraints *b22 = new wxLayoutConstraints;
    b22->centreX.SameAs (btn[0], wxCentreX);
    b22->top.Below        (btn[0], 20);
    b22->width.AsIs(); // PercentOf   (panel, wxWidth, 20);
    b22->height.AsIs(); // PercentOf  (panel, wxHeight, 10);
    btn[1]->SetConstraints(b22);
   
    clist[0] = new MyList(panel, images, 0);
    wxLayoutConstraints *g1 = new wxLayoutConstraints;
    g1->left.SameAs   (panel, wxLeft, 5);
    g1->right.SameAs  (btn[1], wxLeft, 5);  
    g1->top.SameAs    (panel, wxTop, 5);
    g1->bottom.SameAs (panel, wxBottom, 10);
    clist[0]->SetConstraints(g1);
    clist[0]->fs = 0;
    
    clist[1] = new MyList(panel, images, 1);
    wxLayoutConstraints *g2 = new wxLayoutConstraints;
    g2->left.SameAs   (btn[1], wxRight, 5);
    g2->right.SameAs  (panel, wxRight, 5);
    g2->top.SameAs    (panel, wxTop, 5);
    g2->bottom.SameAs (panel, wxBottom, 10);
    clist[1]->SetConstraints(g2);
    clist[1]->fs = 0;
        // Set constraints for panel subwindow
    wxLayoutConstraints *c1 = new wxLayoutConstraints;
    c1->left.SameAs       (this, wxLeft);
    c1->top.SameAs        (this, wxTop);
    c1->right.SameAs   (this, wxRight);
    c1->bottom.SameAs  (this, wxBottom);
    btn[0]->Enable(0);    
    btn[1]->Enable(0);    
    panel->SetConstraints(c1);
}


bool MyApp::OnInit(void)
{
    int fst;

    
      wxInitAllImageHandlers();
#if wxUSE_STREAMS && wxUSE_ZIPSTREAM && wxUSE_ZLIB 
      wxFileSystem::AddHandler(new wxZipFSHandler);
#endif

    ReadConfig();

    frame = new MyFrame(NULL,0,-1,-1,-1,-1);

    SetTopWindow(frame);

    frame->Setup(w, h);
    
    if((fst = GetLsel()) != -1)
    {
        frame->clist[0]->createVFS(fst);
        frame->clist[0]->loadVFS();
    }
    
    if((fst = wxGetApp().GetRsel()) != -1)
    {
        frame->clist[1]->createVFS(fst);
        frame->clist[1]->loadVFS();
    }

    frame->Show(TRUE);
    return TRUE;
}

void MyFrame::Quit(class wxCommandEvent &)
{
    Close();
}

MyFrame::MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h):
        wxFrame(frame, -1, title, wxPoint(x, y), wxSize(w, h))
{

    wxString q;
    if(wxGetApp().GetHelp().size())
    {
        q = wxGetApp().GetHelp();
    }
    else
    {
        q = getenv("WXQT2_HELP_DIR");
    }

    if(q)
    {
#ifdef WINDOWS_IS_EVIL
    {
        size_t n;
        if((n = q.find('\\')) == q.size() - 1)
        {
            q.erase(n, 1);
        }
    }
#endif

        help = new wxHtmlHelpController;
        help->UseConfig(wxGetApp().pConfig);
        help->SetTempDir("");
        help->AddBook(q+"/wxqt2.hhp");
    }
    else
        help = 0;
}


MyFrame::~MyFrame()
{
    int wx,hx;
    if(clist[0]->fs)
    {
        delete clist[0]->fs;
    }
    if(clist[1]->fs)
    {
        delete clist[1]->fs;
    }
    GetSize(&wx,&hx);
    wxGetApp().SetW(wx);
    wxGetApp().SetH(hx);    
    if (help &&  help->GetFrame() )
    {
        help->WriteCustomization(wxGetApp().pConfig);        
        help->GetFrame()->Close(TRUE);
    }
}

int MyApp::OnExit()
{
    SaveConfig();
    return 0;
}

MyList::MyList(wxWindow* w, wxImageList *images, int flg, wxString t) : 
        wxListCtrl(w,-1,wxPoint(-1,-1),wxSize(-1,-1), 
                   wxLC_REPORT|wxSUNKEN_BORDER), id(flg)
{
    SetImageList(images, wxIMAGE_LIST_SMALL);
    SetImageList(NULL, wxIMAGE_LIST_NORMAL);    
    InsertColumn(0, "Name", wxLIST_FORMAT_LEFT, 200);
    InsertColumn(1, "Size", wxLIST_FORMAT_LEFT, 80);
    InsertColumn(2, "Date", wxLIST_FORMAT_LEFT, 120);  
}


void MyList::LD_Click(wxMouseEvent& event)
{
    int j = GetNextItem(-1, wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);

    if(j != -1)
    {
        if(S_ISDIR(fs->fl[j].mode))
        {
            fs->readdir(fs->fl[j].name);
            loadVFS();
        }
        SetItemState(j, 0, wxLIST_STATE_SELECTED);
    }
}

void MyList::R_Click(wxMouseEvent& event)
{
    if(fstype != 0 && fs)
    {
        int i,j,n;
        bool ena[6] = {0,0,1,0,1,0};
        
        if(0 != (n = GetSelectedItemCount()))
        {
            ena[0] = fs->isRW();
//            ena[0] = ena[2] = 1;
            for(j = -1, i = 0; i < n; i++)
            {
                j = GetNextItem(j, wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
                
                if((fs->fl[j].mode & S_IXUSR|S_IFREG) == S_IFREG)
                {
                    ena[5] = 1;
                    break;
                }
            }
        }
        else
        {
            ena[1] = ena[3] = fs->isRW();
        }


        wxMenu *menu = new wxMenu( "Popup");
        menu->Append(ID_MENU_DELETE, "Delete");
        menu->Enable(ID_MENU_DELETE, ena[0]);
        menu->Append(ID_MENU_FORMAT, "Format ...");    
        menu->Enable(ID_MENU_FORMAT, ena[1]);
        menu->Append(ID_MENU_INFO,   "Info");
        menu->Append(ID_MENU_MKDIR,  "Mkdir ...");
        menu->Enable(ID_MENU_MKDIR, ena[3]);
        menu->Append(ID_MENU_VERSION,"Version ...");
        menu->Append(ID_MENU_VIEW,   "View");
        menu->Enable(ID_MENU_VIEW, ena[5]);
        PopupMenu( menu, event.GetX(), event.GetY() );
    }
}

