#ifndef __QLT_H
#define __QLT_H
/*************************************************************
 * qlt.h
 *
 *
 * Copyright (C) 1999 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   $Log: qlt.h,v $
 *   Revision 1.4  2000/04/05 21:05:34  jrh
 *   Help and dll changes
 *
 *   Revision 1.3  2000/04/02 15:40:20  jrh
 *   0.08 changes, cosmetic HCI
 *
 *   Revision 1.2  2000/02/20 14:47:52  jrh
 *   Windows root fixes
 *
 *   Revision 1.1  1999/11/09 20:13:15  jrh
 *   Initial revision
 *
 *
 *************************************************************/
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers
#ifndef WX_PRECOMP
# include "wx/wx.h"
#endif
# include "wx/frame.h"
# include "wx/listctrl.h"
# include "wx/imaglist.h"
# include "wx/bitmap.h"
# include "wx/config.h"
# include <wx/image.h>
# include <wx/wxhtml.h>
# include <wx/filesys.h>
# include <wx/fs_zip.h>
# include <fstream.h>
# include "qltmisc.h"
# include "vfs.h"

class MyList: public wxListCtrl
{
  public:
    MyList(wxWindow* w, wxImageList *, int =0 , wxString = "");
    vfs *fs;
    short fstype;
    void createVFS(short);
    void loadVFS();
    bool isdouble;
    short id;
    void vPopVue(void);
    void vPopDel(void);
    void vPopFmt(void);
    void vPopMkd(void);
    void vPopVer(void);
    void vPopInf(void);    
    vector<int> Selections(void);
  private:
    void LD_Click (wxMouseEvent& event);
    void R_Click (wxMouseEvent& event);    
  protected:
    DECLARE_EVENT_TABLE()
};


class MyFrame: public wxFrame
{
  public:
    MyFrame(wxFrame *, char *, int, int, int, int);
    ~MyFrame();
    void Setup(int,int);
    wxBitmapButton *btn[2];
    wxStatusBar *sbar;
    wxPanel *panel;    
    MyList *clist[2];
    wxImageList *loadimages(wxPanel*);    
  private:
    bool OnClose(void);
    void OnButtons(wxCommandEvent& event);
    void OnSize(wxSizeEvent& event);
    void Quit(wxCommandEvent& event);
    void About(wxCommandEvent& event);
    void Help(wxCommandEvent& event);    
    void Options(wxCommandEvent& event);
    void InstantiateFS(int, int);
    void NewQxl(void);
    void OnMenuHighlight(wxMenuEvent& event){}
    wxHtmlHelpController *help;
  protected:
    DECLARE_EVENT_TABLE()
};

// Define a new application

class MyApp: public wxApp
{
  public:
    MyFrame *frame;
    wxConfig *pConfig;    
    inline short GetLsel() {return lsel;}
    inline short GetRsel() {return rsel;}
    inline short GetQXLMode() {return qxlmode;}    
    inline void SetLsel(short i) {lsel=i;}
    inline void SetRsel(short i) {rsel=i;}
    inline const char* GetNdsk() {return ndisk.c_str();}
    inline const char* GetQflp() {return qlfloppy.c_str();}
    inline const char* GetQdsk() {return qldisk.c_str();}    
    inline void SetNdsk(wxString s) {ndisk=s;}
    inline void SetQflp(wxString s) {qlfloppy=s;}        
    inline void SetQdsk(wxString s) {qldisk=s;}        
    inline const char * GetDevTxt(short i)
    {
        return (i == 0) ? GetNdsk() : (i == 1) ? GetQflp() : GetQdsk();
    }
    inline void SetQXLMode(short l) {qxlmode=l;}
    inline void SetW(int vw) {w=vw;}
    inline void SetH(int vh) {h=vh;}    
    inline wxFont& GetFixFont(){return ffont;}
    inline void SetFixFont(wxFont f){ffont=f;}    
    inline wxString& GetHelp() {return helpcmd;};
  private:
    bool OnInit(void);
    int OnExit(void);
    void ReadConfig(void);
    void SaveConfig(void);
    int w,h;
    short qxlmode;
    short rsel,lsel;
    wxString ndisk;
    wxString qldisk;
    wxString qlfloppy;
    wxString helpcmd;
    wxFont  ffont;
};

#define ID_BUTTON_LEFT  146
#define ID_BUTTON_RIGHT 147

#ifdef __WIN32__
# define WINDOWS_IS_EVIL
#endif

#endif
