//////////////////////////////////////////////////////////////
// qltapp.cc
//
//
// Copyright (C) 1999 Jonathan R. Hudson
// Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//   $Log: qltapp.cc,v $
//   Revision 1.3  2000/04/05 21:05:34  jrh
//   Help and dll changes
//
//   Revision 1.2  2000/02/20 14:47:52  jrh
//   Windows root fixes
//
//   Revision 1.1  1999/11/09 20:13:15  jrh
//   Initial revision
//
//
//////////////////////////////////////////////////////////////
#ifdef _GNUC_
static char rcsid[] __attribute__ ((unused)) ="$Id: qltapp.cc,v 1.3 2000/04/05 21:05:34 jrh Exp $";
#endif
//////////////////////////////////////////////////////////////

#include <wx/wx.h>
#include <wx/config.h>
#include "qlt.h"
    
#ifndef WIN32
# define DEF_FLOPPY "/dev/fd0"
#else
# define DEF_FLOPPY "a:"
#endif

void MyApp::ReadConfig(void)
{
    SetVendorName("dld.org");
    SetAppName("wxqt2");

    pConfig = new wxConfig("wxqt2");
    if(pConfig)
    {        
        long l;
        pConfig->Read("Width", &w, 550);
        pConfig->Read("Height", &h, 500);
        pConfig->Read("left", &l, 0);
        lsel = l;
        pConfig->Read("right", &l, -1);
        rsel = l;
        pConfig->Read("Device", &ndisk, "/");
        pConfig->Read("QXLDev", &qldisk, "/tmp/qxl.win");
        pConfig->Read("QLfloppy", &qlfloppy, DEF_FLOPPY);
        pConfig->Read("Help/Dir", &helpcmd, "");
        pConfig->Read("QXLMode", &l, 0);
        qxlmode = l;
        {
            wxString fnam;
            long fam,fstyl,fweight,fpts;
            
            pConfig->Read("Font/FaceName",&fnam, "");
            pConfig->Read("Font/Family",&fam, wxDEFAULT);        
            pConfig->Read("Font/Style",&fstyl, wxNORMAL);        
            pConfig->Read("Font/Weight",&fweight, wxNORMAL);        
            pConfig->Read("Font/PointSize",&fpts, 10);        
            ffont.SetFaceName(fnam);
            ffont.SetFamily(fam);
            ffont.SetPointSize(fpts);
            ffont.SetStyle(fstyl);
            ffont.SetUnderlined(0);
            ffont.SetWeight(fweight);
        }
    }
}

void MyApp::SaveConfig(void)
{

    if(pConfig)
    {
        pConfig->Write("Width", (long)w);
        pConfig->Write("Height", (long)h);
        pConfig->Write("Device", ndisk);
        pConfig->Write("QXLDev", qldisk);
        pConfig->Write("QLfloppy", qlfloppy);
        pConfig->Write("left", (long)lsel);
        pConfig->Write("right", (long)rsel);
        pConfig->Write("QXLMode", (long)qxlmode);
        pConfig->Write("Font/FaceName", ffont.GetFaceName());
        pConfig->Write("Font/Family", (long)ffont.GetFamily());        
        pConfig->Write("Font/Style", (long)ffont.GetStyle());        
        pConfig->Write("Font/Weight", (long)ffont.GetWeight());        
        pConfig->Write("Font/PointSize", (long)ffont.GetPointSize());        
        delete pConfig;
    }
}
