//////////////////////////////////////////////////////////////
// qltmisc.cc
//
//
// Copyright (C) 1999 Jonathan R. Hudson
// Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//   $Log: qltmisc.cc,v $
//   Revision 1.3  2000/03/16 22:38:51  jrh
//   Updated window positioning
//
//   Revision 1.2  2000/02/20 14:47:52  jrh
//   Windows root fixes
//
//   Revision 1.1  1999/11/09 20:13:15  jrh
//   Initial revision
//
//
//////////////////////////////////////////////////////////////
#ifdef _GNUC_
static char rcsid[] __attribute__ ((unused)) ="$Id: qltmisc.cc,v 1.3 2000/03/16 22:38:51 jrh Exp $";
#endif
//////////////////////////////////////////////////////////////

#include "wx/wxprec.h"
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers
#ifndef WX_PRECOMP
# include "wx/wx.h"
#endif

#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#ifndef __BORLANDC__
# include <unistd.h>
#else
# include <io.h>
#endif

#include "qlt.h"
#include "qltmisc.h"
#ifdef __WIN32__
# include "wx/msw/winundef.h"
#endif
DECLARE_APP(MyApp)

#ifndef WIN32
# define HGT 100
#else
# define HGT 120
#endif


BusyBox::BusyBox(wxWindow *parent, char *title, char *txt, int& res)
        : wxDialog(parent, -1, title, wxDefaultPosition, wxSize(200,HGT), 
                   wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER), flag(res)
{
    SetAutoLayout (TRUE);

    wxPanel *panel = new wxPanel(this, -1);
    wxButton *m_OK = new wxButton(panel, wxID_CLOSE, "Abort");

    wxLayoutConstraints* c;
    c = new wxLayoutConstraints;
    c->centreX.SameAs 	(panel,	wxCentreX);
    c->bottom.SameAs	(panel,	 wxBottom, 5);
    c->height.AsIs();
    c->width.AsIs();
    m_OK->SetConstraints(c);

#ifdef STATICTEXT
    wxStaticText *l1 = new wxStaticText(panel, -1, txt);
    l2 = new wxStaticText(panel, -1,"...........");
    
    c = new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 10);
    c->right.SameAs (panel, wxRight, 10);
    c->top.SameAs (panel, wxTop, 10);
    c->height.AsIs();
    l1->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 10);
    c->right.SameAs (panel, wxRight, 10);
    c->top.SameAs (l1, wxBottom, 10);
    c->bottom.SameAs (m_OK, wxTop, 10);
    c->height.AsIs();
    l2->SetConstraints(c);
#else

    l2 = new wxTextCtrl (panel, -1, txt, 
                         wxDefaultPosition,
                         wxDefaultSize,		
                         wxTE_MULTILINE|wxTE_READONLY);
    (*l2) << "\n\n";
    c = new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 10);
    c->right.SameAs (panel, wxRight, 10);
    c->top.SameAs (panel, wxTop, 10);
    c->bottom.SameAs (m_OK, wxTop, 10);
    l2->SetConstraints(c);
#endif

    c = new wxLayoutConstraints;
    c->left.SameAs (this, wxLeft);
    c->top.SameAs  (this, wxTop);
    c->right.SameAs (this, wxRight);
    c->bottom.SameAs (this, wxBottom);
    panel->SetConstraints(c);
    Layout();
}


void BusyBox::SetText(char *s)
{
#ifdef STATICTEXT
    l2->SetLabel(s);
#else
    long n1,n2;
    n1 = l2->XYToPosition(0, 1);
    n2 = l2->GetLastPosition();
    l2->Replace(n1,n2, s);
#endif
    ::wxYield();
}

void BusyBox::SetBusy()
{
    ::wxBeginBusyCursor();
#ifndef WX20
    ::wxSafeYield(this);
#else
    ::wxYield();
#endif
}

void BusyBox::OnCloseWindow(wxCloseEvent& event)
{
    ::wxEndBusyCursor();
    if(event.CanVeto())
    {
        Destroy();
    }
}

void BusyBox::DoClose(void)
{
    Close();
}

#define DEFSIZE wxDefaultSize


vLog::vLog(wxWindow* parent, char* title, const string& fnam, bool ul) 
        : wxDialog(parent, -1, title, wxDefaultPosition,
                   DEFSIZE, wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER),
          filename(fnam), unlink(ul) 
{
    SetAutoLayout (TRUE);
    wxPanel *panel = new wxPanel(this, -1);
    wxButton *m_OK = new wxButton(panel, wxID_CLOSE, "OK");
    wxTextCtrl *list = new wxTextCtrl (panel, -1, "", 
                                       wxDefaultPosition,
                                       wxDefaultSize,		
                                       wxTE_MULTILINE|wxTE_READONLY);

    list->SetFont(wxGetApp().GetFixFont());
 
    ifstream f(fnam.c_str());
    char buf[256];
    unsigned int ln=0,lc=0;
    size_t nn;

    while(f.getline(buf,sizeof(buf),'\n'))
    {
        ln++;
        if((nn = strlen(buf)) > lc) lc = nn;
        (*list) << buf;
        (*list) << "\n";
    }
    f.close();

#ifndef WX20
    int cw = 10000,ch =10000,mw = 800,mh = 600;
    cw = 64 + lc * list->GetCharWidth();
    ch = 72 + ln * list->GetCharHeight();
    ::wxDisplaySize(&mw, &mh);
    mw = mw *8/10;
    mh = mh *8/10;    
    if(cw > mw) cw = mw;
    if(ch > mh) ch = mh;
    SetSize(cw,ch);
#endif

    wxLayoutConstraints* c;
    c = new wxLayoutConstraints;
    c->centreX.SameAs 	(panel,	wxCentreX);
    c->bottom.SameAs	(panel,	 wxBottom,	10);
    c->height.AsIs();
    c->width.AsIs();
    m_OK->SetConstraints(c);
    
    c = new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 10);
    c->right.SameAs (panel, wxRight, 10);
    c->top.SameAs (panel, wxTop, 10);
    c->bottom.SameAs (m_OK, wxTop, 10);
    list->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (this, wxLeft);
    c->top.SameAs  (this, wxTop);
    c->right.PercentOf (this, wxWidth, 100);
    c->height.PercentOf (this, wxHeight, 100);
    panel->SetConstraints(c);   
    CentreOnParent();
    Layout();
}

void vLog::OnCloseWindow(wxCloseEvent& event)
{
    if(unlink)
    {
        ::unlink(const_cast<char *>(filename.c_str()));
    }
    if(event.CanVeto())
    {
        Destroy();
    }
}

void vLog::DoClose(void)
{
    if(IsModal())
    {
        EndModal(wxID_OK);
    }
    Close();
}

void vLog::OnSize(wxSizeEvent& WXUNUSED(event) )
{
    Layout();
}

BEGIN_EVENT_TABLE(vLog, wxDialog)
   EVT_SIZE(vLog::OnSize)
   EVT_BUTTON(wxID_CLOSE, vLog::DoClose)
   EVT_CLOSE(vLog::OnCloseWindow) 
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(BusyBox, wxDialog)
   EVT_BUTTON(wxID_CLOSE, BusyBox::DoClose)
   EVT_CLOSE(BusyBox::OnCloseWindow) 
END_EVENT_TABLE()



