//////////////////////////////////////////////////////////////
// qxlfs.cc
//
//
// Copyright (C) 1999 Jonathan R. Hudson
// Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//   $Log: qxlfs.cc,v $
//   Revision 1.4  2000/04/02 15:40:20  jrh
//   0.08 changes, cosmetic HCI
//
//   Revision 1.3  2000/02/20 14:47:52  jrh
//   Windows root fixes
//
//   Revision 1.2  2000/01/28 21:39:21  jrh
//   Updated for Win32 no exceptions fix
//
//   Revision 1.1  1999/11/09 20:13:15  jrh
//   Initial revision
//
//
//////////////////////////////////////////////////////////////
#ifdef _GNUC_
static char rcsid[] __attribute__ ((unused)) ="$Id: qxlfs.cc,v 1.4 2000/04/02 15:40:20 jrh Exp $";
#endif
//////////////////////////////////////////////////////////////

#include "vfs.h"
#include "qlt.h"
#include "qxlopt.h"
 
#define EOM "EOM\b\b\b"

DECLARE_APP(MyApp) 

bool qxlfs::CheckVers()
{
    size_t n;
    string z("qxltool ");
    int vers = 0;
    char *p;
    
    n = version.find(z);
    n += z.size();
    
    vers = strtol(version.substr(n,string::npos).c_str(),&p, 10);
    if(p)
    {
        p++;
        vers = vers * 100 + strtol(p, NULL, 10);
    }
    return vers < min_version();
}

int qxlfs::open_fs(string& dev)
{
    int res;
    string rwo(" ");
    forcero = 0;
    if((res = access(dev.c_str(), W_OK)) == 0)    
    {
        rwo = rwo + "-W ";
    }
    else
    {
        rw = 0;
        forcero = 1;
    }
    
    if((res = access(dev.c_str(), R_OK)) == 0)
    {
        char *ep;
        string cmd(QXLTOOL);
        cmd =  cmd + rwo +dev;
        res =
            StartChild(&pipefp, &pid, const_cast<char*>(cmd.c_str()),&ep);
    }
    return res;
}

short qxlfs::SetRW(short val)
{
    string cmd;
    if(forcero)
        val = 0;
    rw = val;
    cmd = (rw) ? "RW" : "RO";
    
    cerr << cmd << " " << rw << endl;
    
    sendcmd(cmd);
    while(getresp(&version))
        ;
    return val;
}

void qxlfs::sendcmd(const string& c)
{
    PPUTS(c.c_str(), pipefp);
    if(c.find("\n") == string::npos)
    {
        PPUTS("\n", pipefp);
    }
}

qxlfs::qxlfs(string dev) : qdosfs()
{
    bool res = false;

    isnative = 0;
    pd = 0;
    
    ndev = dev;
    cwd.erase();
    
    if(open_fs(dev) == 0)
    {
        sendcmd("version");
        while(getresp(&version))
            ;

        if(0 != (res = CheckVers()))
        {
            wxString msg("qxltool version mismatch\n"
                         "Minimum required version is ");
            int n = min_version();
            msg << n / 100 << "." << n % 100; 
            wxMessageBox(msg, "Problem!", wxOK | wxICON_EXCLAMATION);
        }
    }
    else
    {
        wxString msg("Error running qxltool\n");
        msg << dev.c_str() << "\n" << strerror(errno);
        wxMessageBox(msg, "Problem!", wxOK | wxICON_EXCLAMATION);
        res = true;
    }
    verror = (res) ? -1 : 0;
}

qxlfs::~qxlfs()
{
    if(pid)
    {
        sendcmd("quit");
        PID_WAIT(pid);
        PCLOSE(pipefp);
    }
    pid = 0;
}

bool qxlfs::getresp(string *r=0)
{
    char buf[512];
    bool res;
    
    PGETS(buf, sizeof(buf), pipefp);

    if(((res = strncmp(buf, EOM, 6)) != 0) && r != 0)    
    {
        size_t cr;
        *r = buf;

#ifdef WINDOWS_IS_EVIL
        if((cr = r->find('\r')) != string::npos)
        {
            r->erase(cr);
        }
#endif
        if((cr = r->find('\n')) != string::npos)
        {
            r->erase(cr);
        }
    }
    return res;
}

void qxlfs::setcwd(string& dir)
{
    string cd;
    
    cd = "cd " + dir;

    sendcmd(cd);
    while(getresp(0))
        ;

    sendcmd ("pwd");
    while(getresp(&cwd))
        ;
   
    if(cwd == "/")
    {
        cwd.erase();
    }
}

inline string qxlfs::fname(int n)
{
    return fl[n].name;
}

void qxlfs::getlist(vector<FITEM>& lf)
{
    string name;
    FITEM fi;    
    string s,size,date;

    sendcmd("ls");
    
    while(getresp(&s))
    {
        int mode;
        mode = 0;
        name = s.substr(0,36);

        size_t n = name.find_last_not_of(" ");
        if(n != string::npos)
        {
            name.erase(n+1,name.size());
        }

        if(s.substr(53,1) == "(")
        {
            mode = S_IFDIR;
            date = "";
        }
        else
        {
            if(s.substr(65,1) == "(")
            {
                mode = S_IXUSR|S_IFREG;
            }
            else
            {
                mode = S_IFREG;
            }
            date = s.substr(47,17);
        }
        size = s.substr(37,9);

        fi.name = name;
        fi.size = atoi(size.c_str());
        if(date.size())
        { 
            struct tm tm;
            char c;
            istrstream ist(date.c_str());
            memset(&tm, 0, sizeof(tm));
            
            ist >> tm.tm_mday >> c >> tm.tm_mon >> c 
                >> tm.tm_year >> tm.tm_hour >> c 
                >> tm.tm_min >> c >> tm.tm_sec;
            tm.tm_mon--;
            if( tm.tm_year < 60)
            {
                tm.tm_year += 100;
            }
            
            fi.time = mktime(&tm);
        }
        else
        {
            fi.time =-1;
        }
        fi.mode = mode;
        lf.push_back(fi);
    }
}


int qxlfs::readdir(string dir)
{
    FITEM fi;    

    setcwd(dir);
    fl.clear();

    fi.name = ".";
    fi.mode = S_IFDIR;
    fi.size = 0;
    fi.time = -1;
    fl.push_back(fi);
    fi.name = "..";
    fi.mode = S_IFDIR;
    fi.size = 0;
    fi.time = -1;
    fl.push_back(fi);

    getlist(fl);
  
    stat = ndev+ ":" + cwd;

    sort(fl.begin(),fl.end(),cmp_nocase_fn());
    return 0;
}


int qxlfs::in(vfs*f, vector<int>& arry)
{

    verror = 0;
    pd = new BusyBox(wxGetApp().GetTopWindow(),
        "Working..", "Copying:", verror);
    pd->Show(TRUE);
    pd->SetBusy();

    for(unsigned int i = 0; verror == 0 && i < arry.size(); i++)
    {
        string of = f->fl[arry[i]].name;
        if(S_ISDIR(f->fl[arry[i]].mode))
        {
            nrecurse(of);
        }
        else
        {
            in(of);
        }
    }    
    pd->Close();
    pd = 0;
    if(verror)
    {
        ShowError();
        errnam.erase();
        verror = 0;
    }
    return 0;
}

int qxlfs::in(string& d)
{

    string qf,nf;
    size_t spos;
    char *nwd;
    
    qf = d;

    nwd = new char [PATH_MAX];
    getcwd(nwd, PATH_MAX);
    nf = nwd;
    free(nwd);
#ifdef WINDOWS_IS_EVIL
    {
        size_t n;
        if((n = nf.find('\\')) == nf.size() - 1)
        {
            nf.erase(n, 1);
        }
    }
#endif
    nf = nf + "/" + d;
   
    while((spos = qf.find('/')) != string::npos)
    {
        qf.replace(spos,1,"_");
    }
    while((spos = qf.find('.')) != string::npos)
    {
        qf.replace(spos,1,"_");
    }

    if(pd) pd->SetText(const_cast<char*>(qf.c_str()));
    if(qf.size() > 36)
    {
        verror = ENAMETOOLONG;
    }
    else
    {
        string cmd = "wr " + nf + " " + qf;
        
        sendcmd(cmd);
        while(getresp(0))
            ;
    }
    if(verror)
        errnam = qf;
    return 0;
}

#define OP_OUT 1
#define OP_RM  2

void qxlfs::qxlrecurse(string& f, string& fsdir, int op, vfs* ofs)
{
    string lastn;
    string nf;
    vector<FITEM> dl;        
    string cmd;
    char *buf = 0;
    
    lastn = fsdir;
    fsdir = fsdir + f;

    cmd = "cd " + f + "\n";
    sendcmd (cmd);
    while(getresp(0))
        ;
    
    getlist(dl);

    if(ofs) buf = getcwd(0, PATH_MAX);       // GNU ish behaviour !!!!!

    if(op == OP_OUT)
    {
        MKDIR(fsdir.c_str(), 0755);
        if(ofs)
        {
            string fp;
            size_t spos;
            
            fp = fsdir.substr(strlen(buf)+1, string::npos);
            while((spos = fp.find('/')) != string::npos)
            {
                fp.replace(spos,1,"_");
            }
            ofs->mkdir(fp);
        }
    }

    fsdir = fsdir + "/";
    
    vector<FITEM>::iterator q;
    for(q = dl.begin(); verror == 0 && q != dl.end(); q++)
    {
        if(S_ISDIR(q->mode) == 0)
        {
            string disp;
            disp = (cwd.size()) ? cwd + "_" + q->name : q->name;
            
            nf = cvtname(q->name,fsdir);
            pd->SetText(const_cast<char*>(disp.c_str()));
            switch(op)
            {
                case OP_OUT:
                    out(nf, q->name);
                    if(ofs)
                    {
                        string fp = nf.substr(strlen(buf)+1,string::npos);
                        ofs->in(fp);
                    }
                    break;
                case OP_RM:
                    rm(q->name, q->mode);
            }
        }
        else
        {
            qxlrecurse(q->name, fsdir, op, ofs);
        }
    }
    sendcmd ("cd ..");
    while(getresp(0))
        ;

    if(op == OP_RM)
    {
        rm(f,  S_IFDIR);
    }
    fsdir = lastn;

    if(ofs)
    {
        free(buf);
    }
}

int qxlfs::out(vector<int>& arry, vfs*ofs)
{                

    string nf;
    string fsdir;
    string f;
    char *cwd = 0;
    char *newd = 0;
    char *nwd;
    
    if(ofs)
    {
        settmpdir(&cwd, &newd);
    }
   
    verror = 0;

    pd = new BusyBox(wxGetApp().GetTopWindow(),
                     "Working..", "Copying:", verror);

    pd->Show(TRUE);
    pd->SetBusy();
    fsdir = (nwd = getcwd(0,PATH_MAX));
#ifdef WINDOWS_IS_EVIL
    {
        size_t n;
        if((n = fsdir.find('\\')) == fsdir.size() - 1)
        {
            fsdir.erase(n, 1);
        }
    }
#endif
    fsdir += "/";
    free(nwd);
    for(unsigned int i = 0; verror == 0 && i < arry.size(); i++)
    {
        f = fname(arry[i]);
        if((fl[arry[i]].mode &  S_IFDIR) == 0)
        {
            nf = cvtname(f,fsdir);
            pd->SetText(const_cast<char*>(f.c_str()));
            out(nf, f);
            if(ofs)
            {
                string fp;
                fp = nf.substr(fsdir.size(),string::npos);
                ofs->in(fp);
            }
        }
        else
        {
            qxlrecurse(f, fsdir, OP_OUT, ofs);
        }
    }
    
    if(ofs)
    {
        resettmpdir(cwd, newd);
    }
    pd->Close();
    pd = 0;
    if(verror)
    {
        ShowError();
        errnam.erase();
        verror = 0;
    }
    return 0;
}


int qxlfs::out(string& d,string& s)
{

    string cmd;
    cmd = "cp " + s + " >" + d;

    sendcmd(cmd);
    while(getresp(0))
        ;
    return 0;
}

int qxlfs::mkdir(string& d, int mode)
 {
     string r;
     
     if(cwd.size())
     {
         r = qdir+'_'+d;
     }
     else
     {
         r = d;
     }
     if(r.size() && r.size() < 37)
     {
         sendcmd("mkdir "+d);
         while(getresp(0))
             ;

     }
     else
         verror = ENAMETOOLONG;
     if(verror)
         errnam = r;

     return 0; 
}

void qxlfs::rm(string& d, int m)
{
    if(S_ISDIR(m) == 0)
        sendcmd("rm "+d);
    else
        sendcmd("rmdir "+d);       

    while(getresp(0))
        ;
}

int qxlfs::rm(vector<int>& arry)
{
    string nf;
    string fsdir;
    string f;
    char *nwd;
    
    verror = 0;

    pd = new BusyBox(wxGetApp().GetTopWindow(),
                     "Working..", "Deleting:", verror);
    pd->Show(TRUE);
    pd->SetBusy();

    fsdir = (nwd = getcwd(0,PATH_MAX));
    fsdir += "/";
    free(nwd);
    
    for(unsigned int i = 0; verror == 0 && i < arry.size(); i++)
    {
        f = fname(arry[i]);
        if((fl[arry[i]].mode &  S_IFDIR) == 0)
        {
            nf = cvtname(f,fsdir);
            pd->SetText(const_cast<char*>(f.c_str()));
            rm(f, 0);
        }
        else
        {
            qxlrecurse(f, fsdir, OP_RM);
        }
    }
    
    pd->Close();
    pd = 0;
    if(verror)
    {
        ShowError();
        errnam.erase();
        verror = 0;
    }
    return 0;
}

void qxlfs::GetInfo(string& tmp)
{
    sendcmd ("info >"+tmp);
    while(getresp(0))
        ;
}

int qxlfs::format(wxWindow *f)
{
    size_t n;
    string fnam;
    string dlab;
    string s;
    int mb;
    bool r = true;
    int ok = -1;
    
    sendcmd ("info");

    if(0 != (r=getresp(&s)))
    {
        if((n = s.find("file ")) != string::npos)
        {
            n += 5;
            s = s.substr(n, string::npos);
            fnam = s.erase(s.find(' '));
            if(0 != (r=getresp(&s)))
            {
                if((n = s.find("Label ")) != string::npos)
                {
                    dlab = s.substr(6, string::npos);
                }
                if(0 != (r=getresp(&s)))
                {
                    if(0 != (r=getresp(&s)))
                    {
                        if((n = s.find("(")) != string::npos)
                        {
                            mb = strtol(s.substr(n+1,string::npos).c_str(),
                                        0,10);
                        }
                        while(0 != (r=getresp(0)))
                            ;
                        wxString xf,xd;
                        xf = fnam.c_str();
                        xd = dlab.c_str();                        
                        QxlDlg *d = new QxlDlg (f, "Disk Format", 
                                                xf, xd, mb);
                        int res = d->ShowModal();
                        d->Destroy();
                        
                        if(res == wxID_OK)
                        {
                            fnam = xf.c_str();
                            dlab = xd.c_str();                        


                            sendcmd("close");
                            while(0 != (r=getresp(0)))
                                ;
                            ostrstream cmd;
                            cmd << "format " << fnam << " " << mb
                                << " " << dlab;
                            s = cmd.str();
                            sendcmd(s);
                            while(0 != (r=getresp(0)))
                                ;
                            if(access(fnam.c_str(),W_OK) == 0)
                            {
                                sendcmd("open " + fnam);
                                ndev = fnam;
                            }
                            else
                            {
                                errnam = fnam;
                                verror = errno;
                                ShowError();
                                sendcmd("open");
                            }
                            while(0 != (r=getresp(0)))
                                ;
                            ok = 0;
                        }
                        else ok = 0;
                    }
                }
            }
        }
    }

    if(r)
        while(getresp(0))
            ;
    return ok;
}


