/*************************************************************
 * qxlfs.h
 *
 *
 * Copyright (C) 1999 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   $Log: qxlfs.h,v $
 *   Revision 1.1  1999/11/09 20:13:15  jrh
 *   Initial revision
 *
 *
 *************************************************************/

#ifndef _qxlfs_h
#define _qxlfs_h
class qxlfs : public qdosfs
{
  public:
    qxlfs(string);
    ~qxlfs();
    int readdir(string);
    void setcwd(string&);    
    int in(string&);    
    int in(vfs*,vector<int>&);
    int out(string&,string&);    
    int out(vector<int>&,vfs* = 0);
    int format(wxWindow *);
    int mkdir(string&,int=0755);
    int rm(vector<int>&);
    string fname(int n);
    void GetInfo(string&);
    short SetRW(short);
  private:
    int open_fs(string&);
    int close_fs(void);
    void sendcmd(const string &);
    bool getresp(string*);
    bool CheckVers();
    inline int min_version(){return QXLTOOL_MINVERS;}
    void getlist(vector<FITEM>&);
    void qxlrecurse(string&, string&, int, vfs* = 0);
    void rm(string &, int);
    PFILE * pipefp;
    PID_T pid;
    bool forcero;
};
#endif
