//////////////////////////////////////////////////////////////
// qxlopt.cc
//
//
// Copyright (C) 1999 Jonathan R. Hudson
// Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//   $Log: qxlopt.cc,v $
//   Revision 1.4  2000/04/02 15:40:20  jrh
//   0.08 changes, cosmetic HCI
//
//   Revision 1.3  2000/03/16 22:39:21  jrh
//   Updated window positioning
//
//   Revision 1.2  2000/02/20 14:47:52  jrh
//   Windows root fixes
//
//   Revision 1.1  1999/11/09 20:13:15  jrh
//   Initial revision
//
//
//////////////////////////////////////////////////////////////
#ifdef _GNUC_
static char rcsid[] __attribute__ ((unused)) ="$Id: qxlopt.cc,v 1.4 2000/04/02 15:40:20 jrh Exp $";
#endif
//////////////////////////////////////////////////////////////

#include "wx/wxprec.h"
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers
#ifndef WX_PRECOMP
# include "wx/wx.h"
#endif

#include <wx/dialog.h>
#ifndef WX20
#include <wx/statline.h>
#endif
#include "qxlopt.h"
#include <fstream.h>

#define BUT1 120
#define BUT2 121

BEGIN_EVENT_TABLE(QxlDlg, wxDialog)
    EVT_BUTTON(wxID_OK, QxlDlg::OnOK)
    EVT_BUTTON(BUT1, QxlDlg::QxlFileDlg)
END_EVENT_TABLE()

#ifndef WIN32
#define HGT 140
#define WID 350
#else
#define HGT 160
#define WID 380
#endif

QxlDlg::~QxlDlg()
{
}

QxlDlg::QxlDlg(class wxWindow *parent,const wxString &title,
               wxString& fnam, wxString& dnam, int& mb) 
        : wxDialog (parent, -1, title, wxDefaultPosition, wxSize(WID,HGT)),
          rfnam(fnam), rdnam(dnam), rmb(mb)
{
    wxString smb;

    SetAutoLayout(TRUE);
    
    wxPanel *panel = new wxPanel(this);
     
    wxStaticText *l0 = new wxStaticText(panel, -1, "File");
    wxStaticText *l1 = new wxStaticText(panel, -1, "Label");
    wxStaticText *l2 = new wxStaticText(panel, -1, "Size");
    wxStaticText *l3 = new wxStaticText(panel, -1, "(Mb)");
    wxButton *b;
    
    t[0] = new wxTextCtrl(panel, -1, rfnam, wxPoint(-1, -1), 
                                    wxSize(200,-1));
    t[1]= new wxTextCtrl(panel, -1, rdnam, wxPoint(-1, -1), 
                                   wxSize(200,-1));

    wxTextValidator vlad (wxFILTER_NUMERIC);

    smb << rmb;
    
    t[2] = new wxTextCtrl(panel, -1, smb, wxPoint(-1, -1), 
                                    wxSize(100,-1), 0,vlad);

    b = new wxButton(panel, BUT1, "Browse ...");
   
    wxButton *but1  = new wxButton(panel, wxID_OK, "OK",
                                   wxDefaultPosition,
                                   wxDefaultSize);
    
    wxButton *but2  = new wxButton(panel, wxID_CANCEL, "Cancel",
                                   wxDefaultPosition,
                                   wxDefaultSize);
        
    wxLayoutConstraints *c = new wxLayoutConstraints;

    c->left.SameAs (l1, wxRight, 15);
    c->top.SameAs (panel, wxTop, 5);
    c->width.AsIs() ;
    c->height.AsIs();
    t[0]->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (l1, wxRight, 15);
    c->top.SameAs (t[0], wxBottom, 5);
    c->width.AsIs() ;
    c->height.AsIs();
    t[1]->SetConstraints(c);

    c = new wxLayoutConstraints;
    c = new wxLayoutConstraints;
    c->left.SameAs (l1, wxRight, 15);
    c->top.SameAs (t[1], wxBottom, 5);
    c->width.AsIs() ;
    c->height.AsIs();
    t[2]->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->right.SameAs (panel, wxRight, 5);
    c->top.SameAs (panel, wxTop, 5);
    c->width.AsIs() ;
    c->height.AsIs();
    b->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 5);
    c->centreY.SameAs (t[0], wxCentreY);
    c->width.AsIs() ;
    c->height.AsIs();
    l0->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 5);
    c->centreY.SameAs (t[1], wxCentreY);
    c->height.AsIs();
    c->width.AsIs() ;
    l1->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 5);
    c->centreY.SameAs (t[2], wxCentreY);
    c->width.AsIs() ;
    c->height.AsIs();
    l2->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (t[2], wxRight, 5);
    c->centreY.SameAs (t[2], wxCentreY);
    c->height.AsIs();
    c->width.AsIs();
    l3->SetConstraints(c);
#ifndef WX20
    wxStaticLine *ln = new wxStaticLine(panel, -1, 
                                        wxDefaultPosition, wxSize(3,3),
                                        wxHORIZONTAL);
    c = new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 10);
    c->right.SameAs (panel, wxRight, 10);
    c->top.SameAs (t[2], wxBottom, 5);
    c->height.AsIs();
    ln->SetConstraints(c);
#endif
    c =  new wxLayoutConstraints;
    c->left.SameAs (panel, wxLeft, 20);
    c->bottom.SameAs (panel, wxBottom, 5);
    c->width.AsIs() ;
    c->height.AsIs();
    but1->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->right.SameAs (panel, wxRight, 20);
    c->bottom.SameAs (panel, wxBottom, 5);
    c->width.AsIs() ;
    c->height.AsIs();
    but2->SetConstraints(c);

    c = new wxLayoutConstraints;
    c->left.SameAs (this, wxLeft);
    c->top.SameAs (this, wxTop);
    c->right.SameAs (this, wxRight);
    c->height.SameAs (this, wxBottom);
    panel->SetConstraints(c);

    Layout();
} 


void QxlDlg::OnOK(wxCommandEvent& event )
{
    rfnam = t[0]->GetValue();
    rdnam = t[1]->GetValue();    
    rmb = atoi(t[2]->GetValue().c_str());
    EndModal(wxID_OK);
}

void QxlDlg::QxlFileDlg(wxCommandEvent& event )
{
    int res;
    wxString pth;
    
    wxFileDialog* df = new wxFileDialog(this, "Choose a file");
    if((res = df->ShowModal()) == wxID_OK)
    {
        pth = df->GetPath();
        t[0]->SetValue(pth);
    }
    df->Destroy();
}


