/*************************************************************
 * unixfuncs.c
 *
 *
 * Copyright (C) 1999 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   $Log: unixfuncs.c,v $
 *   Revision 1.1  1999/11/09 20:13:15  jrh
 *   Initial revision
 *
 *
 *************************************************************/
static char rcsid[] __attribute__ ((unused)) ="$Id: unixfuncs.c,v 1.1 1999/11/09 20:13:15 jrh Exp $";

#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <linux/fd.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>


int StartChild(FILE **pptr, int *pid, char *cmd)
{
    int sv[2];
    int res = 0;
    char **pa, *args[64];
    char *p1, *p2;

    pa = args;
    for(p1 = cmd; (p2 = strtok(p1, "\t ")); p1 = NULL)
    {
	*pa++ = p2;
    }
    *pa = NULL;

    
    if(0 == (res = socketpair(AF_FILE, SOCK_STREAM, 0, sv)))
    {
        switch((*pid = fork()))
        {
            case 0:
                dup2(sv[1], 0);
                dup2(sv[1], 1);
                execvp (args[0], args);
                _exit(0);
                break;
            case -1:
                res = -1;
                break;
            default:
                *pptr = fdopen(sv[0], "r+");
                setvbuf(*pptr, (char *)NULL, _IOLBF, 0);
                close(sv[1]);
                break;
        }
    }
    return res;
}

int GetFDParams(char *dev)
{
    int fd,r;
    int ds = -1;
    
    if((fd = open(dev, O_RDONLY)) != -1)
    {
        struct floppy_struct f;
	r = ioctl(fd, FDGETPRM, &f);
        if(r == 0)
            ds = f.size;
        else
        {
            struct stat st;
            fstat(fd,&st);
            ds = st.st_size/512;
        }
        close(fd);
    }
    return ds;
}
