//////////////////////////////////////////////////////////////
// vfs.cc
//
//
// Copyright (C) 1999 Jonathan R. Hudson
// Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//   $Log: vfs.cc,v $
//   Revision 1.2  2000/02/20 14:47:52  jrh
//   Windows root fixes
//
//   Revision 1.1  1999/11/09 20:13:15  jrh
//   Initial revision
//
//
//////////////////////////////////////////////////////////////
#ifdef __GNUC__
static char rcsid[] __attribute__ ((unused)) ="$Id: vfs.cc,v 1.2 2000/02/20 14:47:52 jrh Exp $";
#endif
//////////////////////////////////////////////////////////////


#include "vfs.h"
#include "qlt.h"

void qdosfs::ShowError()
{
    if(verror > 0)
    {
        wxString msg("Error: ");
        if(verror > 256)
        {
            verror = verror >> 8;
        }
        msg << verror << "\n" << errnam.c_str() << "\n" 
            << strerror(verror);
        wxMessageBox(msg, "Problem!", wxOK | wxICON_EXCLAMATION);
     }
}


char * qdosfs::fvers()
{
    return const_cast<char*>(version.c_str());
}


void vfs::settmpdir(char **pcwd, char **pnewd)
{
    *pcwd = new char[2*PATH_MAX];
    *pnewd = *pcwd+PATH_MAX;
    getcwd(*pcwd, PATH_MAX);
    TMPNAM(*pnewd);
    MKDIR(*pnewd, 0755);
    chdir(*pnewd);
}

void vfs::resettmpdir(char *cwd, char *newd)    
{
    chdir(cwd);
    rdelete(newd);
    delete [] cwd;
}

void vfs::rdelete(const char *d)
{
    DIR *dir = NULL;
    struct dirent *de;
    
    if (NULL != (dir = opendir(d)))
    {
        while (NULL != (de = ::readdir(dir)))
        {  
            struct stat st;
            if( *de->d_name == '.' &&
                   *(de->d_name+1) == 0 || strcmp(de->d_name, "..") == 0)
            {
                continue;
            }
            string fn (d);
            fn = fn  + '/' + de->d_name;
            if(::stat(fn.c_str(),&st) == 0)
            {
                if(S_ISDIR(st.st_mode))
                {
                    rdelete(fn.c_str());
                }
                else
                {
                    unlink(fn.c_str());
                }
            }
        }
        closedir(dir);
        ::rmdir(d);
    }
}

int qdosfs::nrecurse(string&d)
{
    DIR *dir = NULL;
    struct dirent *de;
    
    if (NULL != (dir = opendir(const_cast<char*>(d.c_str()))))
    {
        string dd;
        dd = d;
        size_t n;
        
        while((n = dd.find('/')) != string::npos)
        {
            dd.replace(n,1,"_");
        }
        
        mkdir(dd);
        while (verror == 0 && NULL != (de = ::readdir(dir)))
        {  
            struct stat st;
            if( *de->d_name == '.' &&
                   *(de->d_name+1) == 0 || strcmp(de->d_name, "..") == 0)
            {
                continue;
            }
            string fn = d + '/' + de->d_name;
            if(::stat(const_cast<char*>(fn.c_str()),&st) == 0)
            {
                if(S_ISDIR(st.st_mode))
                {
                    nrecurse(fn);
                }
                else
                {
                    in(fn);
                }
            }
            else 
            {
                errnam = fn;
                verror = errno;
            }
        }
        closedir(dir);
    }
    else
    {
        errnam = d;
        verror = errno;
    }
    return 0;
}


int cmp_nocase(const string& s, const string& s2)
{
    string::const_iterator p = s.begin();
    string::const_iterator p2 = s2.begin();       
    while(p != s.end() && p2 != s2.end())
    {
        if(toupper(*p) != toupper(*p2))
            return (toupper(*p) < toupper(*p2)) ? -1 : 1;
        ++p;
        ++p2;
    }
    return (s2.size() == s.size()) ? 0 : (s.size() < s2.size()) ? -1 : 1;
}

int less_nocase(const string& s, const string& s2)
{
    int n = cmp_nocase(s,s2);
    return(n == -1) ? 1 : 0;
}

string qdosfs::cvtname(string& name, string& fsdir)
{
    string r;
    size_t n;
    
    r = name;
    
    while((n = r.find('_')) != string::npos)
    {
        r.replace(n,1,".");
    }
    if(fsdir.size())
    {
        r = fsdir + r;
    }
    return r;
}

#ifdef TESTVFS

int main(int ac, char **av)
{
    qlflpfs *fs = new qlflpfs("/dev/fd0");
    
    if(fs)
    {
        int i;
        string dir;
        
        if(ac == 2)
        {
            dir = av[1];
        }
        else
        {
            dir = ".";
        }
        fs->readdir(dir);
        for(int i = 0; i < fs->fl.size(); i++)
        {
            cout << fs->fl[i].name << "\tmode = " << oct <<
                fs->fl[i].mode 
                << endl;
        }
    }
    return 0;
}
#endif
