/*************************************************************
 * vfs.h
 *
 *
 * Copyright (C) 1999 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   $Log: vfs.h,v $
 *   Revision 1.3  2000/02/20 14:47:52  jrh
 *   Windows root fixes
 *
 *   Revision 1.2  2000/01/28 21:39:21  jrh
 *   Updated for Win32 no exceptions fix
 *
 *   Revision 1.1  1999/11/09 20:13:15  jrh
 *   Initial revision
 *
 *
 *************************************************************/

#ifndef _vfs_h_
#define _vfs_h_

#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers
#ifndef WX_PRECOMP
# include "wx/wx.h"
#endif
#include <limits.h>
#include <cstdio>
#include <cstdlib>
#include <vector>
#include <strstream>
#include <fstream>
#include <string>

#include <fcntl.h>
#include <sys/types.h>
#include <time.h>
#include <sys/stat.h>
#include <dirent.h>
#include <cstring>
#ifndef __BORLANDC__
# include <unistd.h>
# include <algo.h>
#else
# define POSIX
# include <io.h>
# include <dir.h>
#endif
#include <signal.h>
#include <errno.h>
#ifndef WIN32
#include <sys/wait.h>
#endif

#include "qltmisc.h"

#ifndef QLTOOLS_MINVERS
# define QLTOOLS_MINVERS 213
#endif

#ifndef QXLTOOL_MINVERS
# define QXLTOOL_MINVERS 113
#endif

#ifndef WIN32
# define PID_WAIT(__p) waitpid(__p, NULL, 0)
# define QLTOOLS "qltools 2>/dev/null"
# define QXLTOOL "qxltool"
# define QXLTOOLSYS "qxltool</dev/null >/dev/null 2>&1"
# define PFILE FILE
# define POPEN(_a,_b,_c) popen(_a,_b)
# define PGETS fgets
# define PPUTS fputs
# define PREAD fread
# define PCLOSE pclose
# define SYSTEM(_a,_b) system(_a)
# define IXPERMS (S_IXOTH|S_IXGRP|S_IXUSR)
# define PIPE_AVAIL(__fp, __buf, __nc) read(fileno(__fp),__buf,__nc)
# define LSTAT lstat
# define PRETVAR
# define SPAWNERR strerror(errno)
# define MKDIR(a,b) ::mkdir(a,b)
# define PID_T pid_t
# define TMPNAM tmpnam 
extern "C" {
    int GetFDParams(const char *);
    int StartChild(PFILE **, int *,const char *,void*);
}

#else
# include "winpipe.h"
# define PID_WAIT(__p) pid_wait(__p)
# define QLTOOLS "qltools"
# define QXLTOOL "qxltool"
# define QXLTOOLSYS "qxltool"
# define PFILE MYWINPROC
# define POPEN winpopen
# define PGETS winpgets
# define PREAD winpread
# define PPUTS winputs
# define PCLOSE winpclose
# define SYSTEM winsystem
# define IXPERMS (S_IXUSR)
# define PIPE_AVAIL(__p1__, __p2__, __p3__) winpipe_avail(__p1__,__p2__,__p3__)
# define LSTAT ::stat
# define PRETVAR char *ep
# define SPAWNERR ep
# define TMPNAM mytmpnam 
# ifdef __CYGWIN32__
#  define MKDIR(a,b) ::mkdir(a,b)
# else
#  define MKDIR(a,b) ::mkdir(a)
# endif
# define PID_T HANDLE
# ifndef PATH_MAX
#  define PATH_MAX MAX_PATH
# endif
# ifndef R_OK
#  define R_OK 4
# endif
# ifndef W_OK
#  define W_OK 2
# endif
#endif

typedef struct
{
    string name;
    off_t size;
    time_t time;
    int mode;
} FITEM;

extern int less_nocase(const string& s, const string& s2);
extern int cmp_nocase(const string& s, const string& s2);

class cmp_nocase_fn
{
  public:
    int operator()
        (const FITEM& f1, const FITEM& f2) const
        {
            string a,b;
            a = (S_ISDIR(f1.mode) ? 'a' : 'z') + f1.name;
            b = (S_ISDIR(f2.mode) ? 'a' : 'z') + f2.name;
            return less_nocase(a,b);
        }
};

class cmp_fn 
{
  public:
    int operator()
        (const FITEM& f1, const FITEM& f2) const
        {
            string a,b;
            a = (S_ISDIR(f1.mode) ? 'a' : 'z') + f1.name;
            b = (S_ISDIR(f2.mode) ? 'a' : 'z') + f2.name;
            return a < b;
        }
};


class vfs 
{
  public:
    vfs() : verror(0),rw(1) {}
    virtual ~vfs() {}
    virtual int readdir(string) = 0;
    virtual void setcwd(string&) = 0;    
    virtual int in(vfs*, vector<int>&) {return 0;}
    virtual int in(string&) {return 0;}    
    virtual int out(vector<int>&,vfs* = 0) {return 0;}
    virtual int out(string&,string&) {return 0;}
    virtual int format(wxWindow *) {return 0;}
    virtual int mkdir(string&,int=0) {return 0;}
    virtual int rm(string&) {return 0;}
    virtual int rm(vector<int>&){return 0;}
    virtual string fname(int n) {return fl[n].name;}
    virtual void GetInfo(string&) {}
    virtual char *fvers() {return 0;}
    virtual short SetRW(short){return true;}
    inline bool isNative() {return isnative;}
    inline bool isRW() {return rw;}
    vector<FITEM> fl;
    string cwd;
    string stat;
    int verror;
  protected:
    void settmpdir(char **, char **);
    void resettmpdir(char *, char *);    
    void rdelete(const char *);
    bool rw;
    bool isnative;
    BusyBox *pd;
    string errnam;
};


class nativefs : public vfs
{
  public:
    nativefs(string);
    int readdir(string);
    void setcwd(string&);    
};

class qdosfs : public vfs
{
  public:
    qdosfs() : vfs() {}
  protected:
    char *fvers();
    string version;
    string ndev;
    string qdir;
    virtual int min_version() = 0;
    virtual bool CheckVers() = 0;
    string cvtname(string&, string&);    
    void ShowError();
    int nrecurse(string&);
};

#include "qlflp.h"
#include "qxlfs.h"

#endif
    
