
/*************************************************************
 * winpipe.c
 *
 *
 * Copyright (C) 1999 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   $Log: winpipe.c,v $
 *   Revision 1.2  2000/02/20 14:47:52  jrh
 *   Windows root fixes
 *
 *   Revision 1.1  1999/11/09 20:13:15 jrh
 *   Initial revision
 *
 *
 *************************************************************/
#if 0
static char rcsid[] __attribute__ ((unused)) ="$Id: winpipe.c,v 1.2 2000/02/20 14:47:52 jrh Exp $";
#endif

#include <windows.h>
#include <winioctl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#ifdef __BORLANDC__	
#include <io.h>
#endif
#include <process.h>
#include <fcntl.h>
#include <sys/stat.h>
#include "winpipe.h"

#if 0
static char *findexe(char *cmd)
{
    char *ep,enam[256],rnam[256];
    strcpy(enam, cmd);
    if((ep = strchr(enam, ' ')))
    {
        *ep = 0;
    }
    if(SearchPath(NULL, enam, ".exe", sizeof(rnam), rnam, &ep))
    {
        ep = strdup(rnam);
    }
    else ep = NULL;
    return ep;
}
#endif

char *mytmpnam(char *p)
{
    static char mytmp[MAX_PATH+1];
    static unsigned int hexid;
    char *s;

    s = (p) ? p : mytmp;
    if (0 != GetTempPath(MAX_PATH, s))
    {
        int n = strlen(s);
        // This is __at least__ as good as Win32 GetTempFileName()
        sprintf(s+n,"WXQT2.%08x.%08x.TMP", getpid(), hexid);
        hexid++;
    }
    else s = NULL;
    return s;
}


void whinge(int res, char **ptr)
{
    if(ptr)
    {
        if(res == 0)
        {
            int err = GetLastError();
            FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER|
                          FORMAT_MESSAGE_FROM_SYSTEM,
                          NULL, err, 0,  (LPTSTR)ptr, 80, (va_list*)NULL);
        }
        else *ptr = NULL;
    }
}

MYWINPROC * winpopen(char *cmd, char *dirn, char **ep)
{
    BOOL res;
    BOOL iread = (*dirn == 'r');
    MYWINPROC *w = malloc(sizeof(MYWINPROC));
    SECURITY_ATTRIBUTES sa,sec_attrs;

    memset(w, 0, sizeof(MYWINPROC));
    sec_attrs.nLength = sizeof(sec_attrs);
    sec_attrs.lpSecurityDescriptor = NULL;
    sec_attrs.bInheritHandle = TRUE;
    sa.nLength = sizeof(sec_attrs);
    sa.lpSecurityDescriptor = NULL;
    sa.bInheritHandle = TRUE;

    res = CreatePipe(&w->inp, &w->oup, &sa, 0);
    if(res)
    {
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	memset(&si, 0, sizeof(si));
	si.cb = sizeof(si);
	si.dwFlags = STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW;
	si.wShowWindow = SW_SHOWMINNOACTIVE;
	si.hStdError = CreateFile("NUL:", GENERIC_WRITE, 0, NULL,
				  CREATE_NEW,FILE_ATTRIBUTE_NORMAL, NULL);
	w->err = si.hStdError;
	si.hStdInput = (iread) ? NULL : w->inp;
	si.hStdOutput = (iread) ? w->oup : NULL;
	
	res = CreateProcess(NULL, cmd, &sec_attrs, NULL, 1, 
			    DETACHED_PROCESS, NULL, NULL, &si, &pi);
	w->proc = pi.hProcess;
	CloseHandle(pi.hThread);
#ifdef  TEST
	printf("res = %d (%s)\n", res, cmd);        
#endif
	whinge(res, ep);
        w->flag = 0;
        w->uhi = w->uho = 0;
    }
    else free(w);
    
    return (res) ? w : NULL;
}

int StartChild (MYWINPROC **pw, HANDLE *pid, char *cmd, char**ep)
{
    BOOL res;

    MYWINPROC *w = malloc(sizeof(MYWINPROC));
    SECURITY_ATTRIBUTES sa,sec_attrs;

    memset(w, 0, sizeof(MYWINPROC));
    sec_attrs.nLength = sizeof(sec_attrs);
    sec_attrs.lpSecurityDescriptor = NULL;
    sec_attrs.bInheritHandle = TRUE;
    sa.nLength = sizeof(sec_attrs);
    sa.lpSecurityDescriptor = NULL;
    sa.bInheritHandle = TRUE;

    if(0 != (res = CreatePipe(&w->inp, &w->oup, &sa, 0)))
    {
        res = CreatePipe(&w->uhi, &w->uho, &sa, 0);
        if(res)
        {
            STARTUPINFO si;
            PROCESS_INFORMATION pi;
            memset(&si, 0, sizeof(si));
            si.cb = sizeof(si);
            si.dwFlags = STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW;
            si.wShowWindow = SW_SHOWMINNOACTIVE;
            si.hStdError = CreateFile("NUL:", GENERIC_WRITE, 0, NULL,
                                      CREATE_NEW,FILE_ATTRIBUTE_NORMAL, NULL);
            w->err = si.hStdError;
            si.hStdInput = w->uhi;
            si.hStdOutput = w->oup;
	
            res = CreateProcess(NULL, cmd, &sec_attrs, NULL, 1, 
                                DETACHED_PROCESS, NULL, NULL, &si, &pi);
            w->proc = pi.hProcess;
            CloseHandle(pi.hThread);
#ifdef  TEST
            printf("res = %d (%s)\n", res, cmd);        
#endif
            whinge(res, ep);
            w->flag = 0;
        }
    }
    if(res == 0)
    {
        free(w);
        return -1;
    }
    else
    {
        *pw = w;
        *pid = w->proc;
        return 0;
    }
}

int winsystem(char *cmd, char **ep)
{
    STARTUPINFO si;
    PROCESS_INFORMATION pi;
    BOOL res;
    DWORD sts;
    char *of ;
    char *dcmd ;
    SECURITY_ATTRIBUTES sec_attrs;
    
    dcmd = strdup(cmd);
    if(NULL != (of = strchr(dcmd, '>')))
    {
        cmd = dcmd;
        *of = 0;
        of++;
    }
    sec_attrs.nLength = sizeof(sec_attrs);
    sec_attrs.lpSecurityDescriptor = NULL;
    sec_attrs.bInheritHandle = TRUE;
    memset(&si, 0, sizeof(si));
    si.cb = sizeof(si);
    si.dwFlags = STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW;
    si.wShowWindow = SW_SHOWMINNOACTIVE;
    si.hStdInput = CreateFile("NUL:", GENERIC_READ, 0, NULL, 
			      CREATE_NEW,FILE_ATTRIBUTE_NORMAL, NULL);
    si.hStdError = CreateFile("NUL:", GENERIC_WRITE, 0, NULL, 
			      CREATE_NEW,FILE_ATTRIBUTE_NORMAL, NULL);
    if(of == NULL)
    {
	of = "NUL:";
    }
    si.hStdOutput  =  CreateFile(of, GENERIC_WRITE, 0, NULL, 
				 CREATE_NEW,FILE_ATTRIBUTE_NORMAL, NULL);
    res = CreateProcess(NULL, cmd, &sec_attrs, NULL, TRUE, 
			DETACHED_PROCESS, NULL, NULL, &si, &pi);
    whinge(res, ep);
    CloseHandle(pi.hThread);        
    if(WaitForSingleObject(pi.hProcess, INFINITE) != WAIT_FAILED)
    {
        GetExitCodeProcess(pi.hProcess, &sts);
        whinge(sts,ep);
#ifdef TEST
        printf("Result is %d\n", sts);
#endif
    }
    CloseHandle(si.hStdError);        
    CloseHandle(si.hStdInput);        
    CloseHandle(si.hStdOutput);            
    CloseHandle(pi.hProcess);            
    if(dcmd) free(dcmd);
    return sts;
}

int winpipe_avail(MYWINPROC *w, char *buf, size_t len)
{
    int rv;
    BOOL res;
    DWORD rb;
    DWORD av = 0,sts = 0;
    
    res = PeekNamedPipe(w->inp, NULL, 0, NULL, &av, NULL);
    if(res == 0  || av == 0)
    {
        if(0 != (res = GetExitCodeProcess(w->proc, &sts)) && sts != STILL_ACTIVE)
            rv = 0;
        else
            rv = -1;
    }
    else rv = (len < av) ? len : av;

    if(rv > 0)
    {
        res = ReadFile(w->inp, buf, rv, &rb, NULL);        
        if(res == 0)
        {
            rv = 0;
        }
        else
            rv = rb;
    }
    return rv;
}

char * winpgets(char *buf, size_t len, MYWINPROC *w)
{
    char *b = buf;
    char *r = buf;
    int rv, n;
    
    for(n = 0; n < (int)len-1; )
    {
        if(w->flag)
        {
            r = NULL;
            break;
        }
        else
        {
            rv = winpipe_avail(w, b, 1);
            if(rv > 0)
            {
                if(*b == '\n')
                {
                    b++;
                    *b = 0;
                    break;
                }
                else
                {
                    n++;b++;
                }
            }
            else if(rv == 0)
            {
                if(n)
                {
                    r = buf;
                    *b = 0;
                }
                else
                {
                    r = NULL;
                }
                w->flag = 1;
                break;
            }
            else
            {
                Sleep(1);    
            }
        }
    }
    return r;
}
int winputs(const char *buf, MYWINPROC *w)
{
    return winpwrite((char *)buf, strlen(buf), 1, w);
}



int winpwrite (char *buf, size_t len, size_t one, MYWINPROC *w)
{
    DWORD nb;
    int res;
    
    int rv = -1;
    
        // write to uhi
    if(w->uho)
    {
        
        res = WriteFile(w->uho, buf, len*one, &nb, NULL);
        if(res == 0)
        {
            rv = 0;
        }
        else
            rv = nb;
    }
    return rv;
}

int winpread (char *buf, size_t len, size_t one, MYWINPROC *w)
{
    char *b = buf;
    int rv, n;
    len = len * one;
    
    for(n = 0; n < (int)len; )
    {
            if(w->flag)
            {
                n = 0;
                break;
            }
            else
            {
                rv = winpipe_avail(w, b, 1);
                if(rv > 0)
                {
                    n++;b++;
                }
                else if(rv == 0)
                {
                    w->flag = 1;
                    break;
                }
                else
                {
                    Sleep(1);    
                }
           }
     }
    return n;
}

void pid_wait(HANDLE pid)
{
    int res;
    res = WaitForSingleObject(pid, 500);
    if(res == WAIT_FAILED || res == WAIT_TIMEOUT)
    {
        TerminateProcess(pid, 0);
    }
}


void winpclose(MYWINPROC *w)
{
    if(w)
    {
        if(w->inp) CloseHandle(w->inp);
        if(w->oup) CloseHandle(w->oup);
        if(w->err) CloseHandle(w->err);    
        if(w->proc) CloseHandle(w->proc);       
        if(w->uhi) CloseHandle(w->uhi);
        if(w->uho) CloseHandle(w->uho);
        free(w);
    }
}

#ifndef IOCTL_DISK_GET_DRIVE_GEOMETRY
# define IOCTL_DISK_GET_DRIVE_GEOMETRY (7 << 16)
#endif

int GetFDParams(const char *dev)
{
     int fd;
     int ds = 0;
     OSVERSIONINFO osv;
     osv.dwOSVersionInfoSize = sizeof(osv);
     if(*dev == '\\' && *(dev+1) == '\\')
     {
        if(GetVersionEx(&osv) && osv.dwPlatformId == VER_PLATFORM_WIN32_NT)
        {
            HANDLE h;
            DISK_GEOMETRY dg;
            DWORD br;
            h = CreateFile(dev, 0, FILE_SHARE_WRITE, NULL, OPEN_EXISTING,
                            0, NULL);
            if(h != INVALID_HANDLE_VALUE)
            {
                if(DeviceIoControl(h, IOCTL_DISK_GET_DRIVE_GEOMETRY, NULL, 0, &dg,
                            sizeof(dg), &br, NULL))
                {
#ifdef __MINGW32__
                    ds = dg.Cylinders.LowPart*dg.TracksPerCylinder*dg.SectorsPerTrack;
#else
                    ds = dg.Cylinders.u.LowPart*dg.TracksPerCylinder*dg.SectorsPerTrack;
#endif
                    
#ifdef TEST
                    printf("this device has %dc, %dt, %ds, = %d\n", 
                            dg.u.Cylinders, dg.TracksPerCylinder,
                            dg.SectorsPerTrack, ds);
#endif  
                }
                CloseHandle(h);
            }
        }
     }
     else
     {
         fd = open(dev, O_RDONLY|O_BINARY);
         if(fd != -1)
        {
            struct stat st;
            fstat(fd, &st);
            ds = st.st_size / 512;
        }
    }
    return ds;
}

#ifdef TEST
int main(int ac, char **av)
{
    MYWINPROC *fp;
    char *ep;
    int r;
    HANDLE pid;
    char buf[256];
    
    printf("%s --- Win32 CreateProcess test 3\n", av[0]);    
#if 0
    if((fp = winpopen(av[1], "r",&ep)))
    {
        char buf[256];
        while((winpgets(buf, 256, fp) != NULL))
        {
            fputs(buf, stdout);
        }
        winpclose(fp);
    }
    else
    {
        puts(ep);
        LocalFree(ep);
    }
#else
    r = StartChild (&fp, &pid, av[1], &ep);
    printf ("result = %d\n", r);
    if(ep)
    {
        puts(ep);
        LocalFree(ep);
    }
    winputs(av[2], fp);
    winputs("\n", fp);
    
    while(winpgets(buf, sizeof(buf), fp))
    {
        if(strncmp(buf, "EOM", 3) == 0)
            break;
        fputs(buf, stdout);
    }
#endif
    return 0;
}
#endif
