/*************************************************************
 * winpipe.h
 *
 *
 * Copyright (C) 1999 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jrhudson@bigfoot.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   $Log: winpipe.h,v $
 *   Revision 1.2  2000/02/20 14:47:52  jrh
 *   Windows root fixes
 *
 *   Revision 1.1  1999/11/09 20:13:15  jrh
 *   Initial revision
 *
 *
 *************************************************************/

#include <windows.h>

typedef struct 
{
    HANDLE inp;
    HANDLE oup;
    HANDLE uho;
    HANDLE uhi;
    HANDLE err;
    HANDLE proc;
    int flag;
} MYWINPROC;

#ifdef __cplusplus
extern "C" {
#endif
    MYWINPROC * winpopen(char *, char *, char **eb);
    char * winpgets(char *, size_t, MYWINPROC *);
    void winpclose(MYWINPROC *);
    int winputs(const char *buf, MYWINPROC *w);
    int winsystem(char *, char **eb);
    int winpipe_avail(MYWINPROC *w, char *buf, size_t len);
    int winpread (char *, size_t, size_t, MYWINPROC *);
    int winpwrite (char *, size_t, size_t, MYWINPROC *);    
    int StartChild (MYWINPROC **, HANDLE *, char *, char**);
    int GetFDParams(const char *);
    void pid_wait(HANDLE pid);
    char *mytmpnam(char *);
#ifdef __cplusplus
}
#endif



