( Tool for printing on EPSON printer, and for conversion of 
character sets in files, QL / IBM. 

Copyright @ Ewald Pfau, 1994. Fidonet: 2:316/9.0

Distribution only with the unchanged version of this file 
at least as a part of what is distributed. 

QL2IBM and IBM2QL will take string parameters for one filename 
as input and output. 

EPSON-CVT will take string parameters for input file and for 
separate output file. QL with MGG-ROM should be switched to TRA 
0 for printing the output spool file. For characters which need 
translation code on EPSON printers, this code is added in the 
output file. Care is taken to scan for characters belonging to 
the same character set, to minimize printer switching. For 
testing purposes, action may be watched by uncommenting 
SHOW-IVAL in REPL-FILE. U.S., French and German character sets 
are supported. Others could be added, following the scheme of 
the tables and adjusting the constant value #TABLES.

For definition of tables, here a contiguos data area is expected 
with separate code and names area. )

decimal
marker noepson

\ testline /QL:
\ abcde |  fghij |  klmno | {}[] pqrst |  uvwxy | z
\ testline /IBM:
\ abcde |  fghij |  klmno | {}[] pqrst |  uvwxy | z

create forig      here
    35 c,  36 c,  64 c,    ( #$@)
    91 c,  92 c,  93 c,    ( [\])
    94 c,  96 c, 123 c,    ( ^'{)
   124 c, 125 c, 126 c,    ( |}~)
                  here swap -
constant #frep

create ffrench
    35 c,  36 c, 141 c,    ( # $ )
   186 c, 136 c, 182 c,    (   )
    94 c,  96 c, 131 c,    ( ^ ' )
   154 c, 144 c, 126 c,    (   ~)

create fgerman
    35 c,  36 c, 182 c,    ( # $ )
   160 c, 164 c, 167 c,    (   )
    94 c,  96 c, 128 c,    ( ^ ' )
   132 c, 135 c, 156 c,    (   )

create ibmorig      here
    35 c,  36 c,  64 c,    ( #$@)
    91 c,  92 c,  93 c,    ( [\])
    94 c,  96 c, 123 c,    ( ^'{)
   124 c, 125 c, 126 c,    ( |}~)
                  here swap -
constant #frep

create ibmfrench
    35 c,  36 c, 133 c,    ( # $ )
   248 c, 135 c,  21 c,    (   )
    94 c, 156 c, 130 c,    ( ^  )
   151 c, 138 c, 126 c,    (   ~)

create ibmgerman
    35 c,  36 c,  21 c,    ( # $ )
   142 c, 153 c, 154 c,    (   )
    94 c, 156 c, 132 c,    ( ^  )
   148 c, 129 c, 225 c,    (   )

3 constant #rline
create rline   27 c, char R c, 0 c, align

: RCODE!       rline 2 + c! ;

3 constant #tables

create fromscrt  256 1+ 1+ allot
create linescrt  256 1+ 1+ allot
create iline     256 dup + cells allot

variable #items
variable #lines
variable olast

\ create backspace 8 c, bl c, 8 c, align
\
\ : .INFO        olast @ ?dup if 0 do backspace 3 type loop then 
\                tuck type olast ! ;

: .INFO        olast @ ?dup if 0 do del loop then 
               tuck type olast ! ;

( ------------------------------------------------------------)

: TABLE@       ( os field -- b)
   ( running on QL:) 
   #frep um* drop + forig + c@ ;

\  ( running on DOS:)
\  #frep um* drop + ibmorig + c@ ;

: >IVAL        ( # -- a)
   dup + cells iline + ;

: >IADR        ( # -- a)
   dup + 1+ cells iline + ;

: ILINE-ADD    ( a field --)
   #items @ tuck >ival ! >iadr ! 1 #items +! ;

: IVAL-SWAP    ( #> ># --)
   tuck dup >iadr @ swap >ival @ 
	       2swap 2dup swap 2swap
   do	       dup 1- swap
	       over >ival @ over >ival !
	       over >iadr @ over >iadr !
	       drop 
   loop        drop
   tuck  >ival ! >iadr ! ;

: 'IVAL-SWAP     ( # # --)
   2dup over >ival @ over >ival @ swap
        rot  >ival ! swap >ival !
        over >iadr @ over >iadr @ swap
        rot  >iadr ! swap >iadr ! ;

: IVAL-MIN      ( #> #@ -- #)
                over 1+ #items @ 2dup u<
   if           swap 
      do        i >iadr @ ?dup
         if        2dup u<
            if     drop 
            else   nip nip i swap 
         then then 
      loop 
   else         2drop then drop ;

: SKIP-ADS      ( #> ># --)
                tuck >iadr @ rot rot 
   do           i >iadr @ ?dup
      if        over =
         if     0 i >iadr ! 
   then then loop drop ;

: IVAL-SORT     ( --)
                #items @ ?dup
   if           1- ?dup
   if 0 do      i dup dup >iadr @ ?dup
      if        ival-min 2dup -
         if     2dup skip-ads
                2dup ival-swap
      then then 2drop 
  loop then then ;

: IVAL-SKIPS   ( -- // needs sorted table)
               #items @ ?dup
   if          1- ?dup
   if          0 tuck 
   do          i 1+ over >iadr @
      if            dup  >iadr @
         if    over >ival @ over >ival @ =
            if    0 swap >iadr !
            else  nip then
         else  drop then
      else     nip  then
   loop drop then then ;

: SCAN-LINE    ( --)
               0 #items ! #tables 0
   do          #frep 0
      do       fromscrt count
         begin i j table@ scan ?dup
         while over fromscrt - linescrt +
               i 0 table@ over c!
               j iline-add 1 /string
         repeat drop
     loop
  loop         ;

: ESC-WRITE    ( hdl # --)
   rcode! rline #rline rot write-file throw ;

: REPL-WRITE   ( hdl --)
               linescrt count rot
               #items  @ ?dup
   if 0 do     i >iadr @ ?dup
      if       swap >R >R
               over R> over - tuck
               R@ write-file throw
               /string R>
               dup i >ival @ esc-write
   then loop then write-line throw ;

: SHOW-IVAL    ( -- // for testing only)
   #items @ ?dup if dup 0
   do i >iadr @ ?dup if linescrt - fromscrt + 
                        c@ emit else space then loop cr dup 0
   do i >iadr @ ?dup if c@ emit else space then loop cr     0
   do i >iadr @      if
      i >ival @  0 <# # #> type else space then loop cr cr then ;

: COUNT-LINES  ( hdl -- #)
   >R 0  begin  fromscrt 255 R@ read-line throw
   while drop 1+ repeat drop 0. R> reposition-file throw ;

: REPL-FILE    ( hdl> >hdl --)
               0 olast !  
               over count-lines #lines !
   begin       over fromscrt 1+ 255 rot read-line throw
   while       fromscrt c! fromscrt linescrt 256 move
               scan-line  ival-sort  ival-skips
               ( show-ival) dup repl-write
               -1 #lines +! #lines @ dup 7 and 7 =
               if 0 <# #s #> .info else drop then
   repeat      drop close-file throw close-file throw 
               0. .info ;

: EPSON-CVT    ( a> n  >a n  --)
   2swap    r/o   open-file throw
   rot rot  r/w create-file throw repl-file ;

: CVT-LINE     ( tbl> >tbl #tbl a> >a n --)
               swap >R         rot R> swap ?dup
   if 0 do     ( t> >t a> n >a)
               >R 2over        c@ >R c@ >R 2dup
      begin    R@ scan ?dup
      while    >R >R over R@ swap -
               R> R> rot
               R> R> rot R@ +  over swap c!
               >R >R 1 /string
      repeat   drop 2R> 2drop 2swap
               1+ swap 1+ swap 2swap R>
   loop then   drop 2drop 2drop ;

: QL2IBM       ( a n --)
               r/w open-file throw >R
   begin       R@ file-position throw
               fromscrt 255 R@ read-line throw
   while       ?dup
      if       rot rot R@ reposition-file throw
               >R fromscrt linescrt R@ move
               ffrench ibmfrench #frep fromscrt linescrt R@ cvt-line
               fgerman ibmgerman #frep fromscrt linescrt R@ cvt-line
               linescrt R> R@ write-line throw
      else     2drop then
   repeat      drop 2drop R> close-file throw ;

: IBM2QL       ( a n --)
               r/w  open-file throw >R
   begin       R@ file-position throw
               fromscrt 255 R@ read-line throw
   while       ?dup 
      if       rot rot R@ reposition-file throw
               >R fromscrt linescrt R@ move
               ibmfrench ffrench #frep fromscrt linescrt R@ cvt-line
               ibmgerman fgerman #frep fromscrt linescrt R@ cvt-line
               linescrt R> R@ write-line throw
      else     2drop then
   repeat      drop 2drop R> close-file throw ;


