( Random test of a dynamic heap.
Written by Ewald Pfau @ 2:316/9@fidonet, Jan 1993

Distribution only with the unchanged version of this file 
at least as a part of what is distributed.)

( ------------------------------------------------------------
This program for first will allocate memory areas from a 
common heap, and then continuosly resize these areas. The actual 
size of each area is chosen quasi randomly, as well as which 
area will be resized next.

Each time resizing gains into a change of heapsize, a line is 
diplayed, showing the amount of unused memory, the number of 
runs since start, and the parameters of the resize action: 
address and size from where memory has been released, and 
address and size of the resized area. 

Make a choice below, between the return values of 'unused' or 
'available' to reflect the current state of allocated heap 
memory according to implementation. 

If loaded, the program is called with 'recs'.)

( ------------------------------------------------------------
Some key switches: 

Each other key except the ones mentioned below will give a short 
helpline.

? - will give some lines about what this tool does.
h - will do the same.

l - will show a headerline for the continuosly shown output 
lines.

r - will start a general loop of 'resizing' all memory areas 
with their own size to gain new addresses. This may pack all the 
heap to be more compact. The gain from packing is shown. 

space - will pause until a key is pressed.

esc   - will stop the program, but first all allocated memory is 
set free again.)

( ------------------------------------------------------------
The way this works, does not guarantee secure operation, so 
perhaps the program may end with an 'out of memory'. This will 
happen, if after a resizing action the amount of unused memory 
drops below a given value. This will happen, if resizing is not 
done correctly.

This may happen, if during allocation at begin, a lot of 
small areas had been created, and during resizing all of these 
areas will become much bigger. Quasi randomly, the count of 
areas is the result of the sizes of these areas when firstly 
allocated.)

( ------------------------------------------------------------
Compatibility: Should run under dpANS Forth. Required: 

MEMORY    for: 'allocate', 'free', 'resize';
CORE EXT  for: 'unused, 'pad', 'nip', 'tuck';
DOUBLE    for: 'd+', 
FACILITY  for: 'key?';

** '8 emit' sets the cursor back one position in the output line. 
** 27 is the value returned by 'key' when the escape key is struck.
** 'key?' could be avoided in replacing key evalution by an end 
term, or otherwise run until jobkill or reboot if no overrun 
occurs. Either a better hideout for 'key?'.

** 'pad', 'nip', 'tuck', and 'd+' may be uncommented below.
For 'pad', check implementation for use of memory beyond of 
'here'. )  ( 
: PAD      here 256 + ; 
: NIP      swap drop ; 
: TUCK     swap over ; 
: +CY      2dup 0< swap 0< xor if + 0< 0= else drop 0< then ;
: D+       rot + >R  2dup +cy if R> 1+ >R then + R> ;
           )
( ------------------------------------------------------------
For better run the return value of 'unused' may be used if it is 
mirroring the current size of allocated heap memory. 'Available' 
is less of use for this purpose, since it should also reflect the 
size of the gaps within the allocated areas.)

  : REC-UNUSED   postpone unused    ; immediate
( : REC-UNUSED   postpone available ; immediate)

( 'max-alloc' holds the maximum size of one area.
'Topfrac' and 'bottomfrac' hold the values, by which the 
initially found value of 'unused' or 'available' will be 
divided, so the quotients are the limits for firstly allocating, 
as top, and for resizing later on, as bottom. The latter value 
is being incremented by the difference of 'pad' and 'here', and 
by the size of a table holding all the addresses of allocated 
areas.)

 decimal private
   512 constant MAX-ALLOC
    64 constant BOTTOMFRAC
    64 constant GARBAGEFRAC
    4  constant TOPFRAC

   27 constant #ESC
      variable #TOP
      variable #BOTTOM
      variable #GARBAGE
      variable #COLLECT
      variable #VALS
      variable SEED

( ------------------------------------------------------------
All that is needed for output.)

( 'Busy' is shown by a rotating dash - the momentarily output 
orientation of the dash depends on the parameter given. So 
counting up will give 'left turn', counting down 'right turn'.)

create BACK$   8 c, bl c, 8 c, bl c,
create BUSY$   char | c, char \ c,
               char - c, char / c,

\ : BACKSPACE    ( ** '8 emit' will put the cursor back one)
\               back$ 3 type ;

: BACKSPACE    del ;

: BACKSPACES   ?dup if 0 do pause backspace loop then ;

: NO.BUSY      ( ** delete the last shown 'busy'-dash)
\               back$ 4 type ;
               backspace space ;

: .BUSY        ( u --) 
               ( ** provide output of 'busy')
               backspace 3 and busy$ + c@ emit ;

: VU.          ( ** print aligned an unsigned number)
               0 <# #s #> 6 over - 0 max spaces type space ;

: .#.          ( ** print a number ending with a dot)
               0 <# #s #> type [char] . emit space ;

: D[#]         ( d n --)
               ( ** print aligned a double number in brackets)
               >R <# [char] ] hold #s
                     [char] [ hold 
               #> R> over - 0 max 
               spaces type space ;

: .HEAD        cr
               ( ** print one help line)
   (  12345671234567123456712345671234567123456789012) 
(  ." unused | old /source | new /target |  # of runs  " ;
)  ." unused | source /old | target /new |  # of runs  " ;

: .OPT         cr
               ( ** print some help lines)
   ." Random test of dynamic heap by continuosly resizing." cr
   ."        Stopped when the music ends."                  cr
(  ." esc=stop / space=pause / r=rearrange / h=header / ?=help " ;)
   ." space=pause / r=rearrange / h=help / ?=help " ;

1 s" flp2_primes_z" r/o open-file throw load-file private

              variable last-dir
: INIT    primes wake pause ;  
          ( ** Perhaps something to be started at begin)

: DE-INIT ; 
          ( ** Perhaps something to de-initialize when finished)

: GO-ON?  -1 ;
          ( ** Perhaps some reason not to go on)

( ------------------------------------------------------------
Addressing, random numbers, allocation and de-allocation:)

: 'RND         ( -- u)
               ( ** provide a pseudo random number)
               seed @  259 um* drop 3 + dup seed ! ;

\ R.N.G. from P.U.G. converted to FORTH               5FEB85DAR 
: RAND 
   seed DUP @  DUP 4 rshift ( 16 /)
   XOR  DUP 15 AND 
   11 lshift   ( 2048 *)
   XOR DUP ROT ! ;
\                                   - - - - - - - - - - - - - -

: RND          ( u -- u)
               ( ** random number below a given limit)
               'rnd ( rand) um* nip ;

: UMAX         ( u u -- u)
               ( ** unsigned the bigger one)
               2dup u< if swap then drop ;

( The addresses and sizes of the allocated areas are held in a 
table starting at 'pad'. The count of areas is held in '#vals'
Addressing is done in giving the number of the table entry.)

: VALS         ( u -- u+)    dup + cells ;
: VAL-         ( a -- a-)    2 cells - ;

: VAL2@        ( # -- n n)   vals pad + 2@ ;
: VAL2!        ( # -- n n)   vals pad + 2! ;
: VALSAVE      ( n n --)     #vals @ val2! 1 #vals +! ;

: VALXCHG      ( # # --)     
               2dup swap >R >R
                  val2@ rot val2@ 
               R> val2! R>  val2! ;

: VALMIN       ( # a # a -- # a)
               rot 2dup u< if drop rot drop else nip nip then ;

: VALSORT      ( --)
               ( ** sort table by ascending addresses)
               ." sorting  "
               #vals @ ?dup 
   if          1-      ?dup 
   if 0 do     pause i dup val2@ drop
               over 1+ #vals @   2dup u<
      if       swap
      do       pause i dup val2@ drop 
               valmin
      loop     drop i 2dup =
         if    2drop else valxchg 
         then  
      else     2drop 2drop then
               i .busy
   loop        no.busy
   then then   9 backspaces ;


: RNDVAL       ( -- n)       max-alloc  rnd ;
: RNDADR       ( -- #)       #vals @ 1- rnd ;

: SET-TOP      ( --)
               ( ** save start value of available)
               rec-unused #top ! ;

: SET-BOTTOM   ( -- u)
               ( ** save limit for resizing)
               #top  @ 0 bottomfrac um/mod nip
               #vals @ vals  max-alloc + 
               pad here - + 
               tuck umax  #bottom ! max-alloc +
               #top  @ 0 garbagefrac um/mod nip
               umax #garbage ! ;

: INC-BOTTOM   ( -- u)
               ( ** limit for allocating)
               #top @  0 topfrac um/mod nip  ;

: ALLOC'D      ( -- u)
               ( ** sum of allocated areas)
               0 #vals @ ?dup if 0 do
               i val2@ nip + loop then ;

: INCS         ( -- err#)
               ( ** do all the allocation)
               space 
   begin       pause inc-bottom rec-unused u<
   while       rndval dup allocate ?dup 0=
   while       swap  valsave 
               #vals @ .busy
   repeat      nip
   else        no.busy     #vals @ 0. d[#] 
               ."  memory areas. " 0 then
               set-bottom  ;

: DECS         ( -- err#)
               ( ** do all the de-allocation)
               #vals @
   begin       pause dup 
   while       1-   dup  val2@ 
               drop free ?dup 0=
   while       dup     .busy
   repeat      else 0 
   then                 no.busy 
               swap  #vals !  set-top ;

( ------------------------------------------------------------
Provide the general loop of continuosly resizing:)

: RERECS       ( -- err#)
               ( ** do a garbage collection)
               cr rec-unused 
               #collect dup @ 1+ dup rot !  
               0. d[#] ." rearranging ...  "
               valsort  #vals @ 
  begin        pause ?dup
  while        1-  dup dup val2@ 
               tuck resize ?dup 0=
  while        swap    rot val2!
               dup .busy 
  repeat       >R 2drop 2drop R>
  else         0 
  then         no.busy rec-unused rot -
               ." gains 'unused' by:  " vu. ;

: RERECS?     ( -- err#)
              #garbage @ rec-unused u<
              if 0 else rerecs then ;

: .HELP         cr
                ( ** print some help lines)                  .opt cr cr
   ." (Meanwhile primes are calculated in one task - "  cr .p ." .)" cr
   ." A line is shown if size of unused memory changes."             cr
   ." Will stop if 'unused' drops below "              #bottom @ .#. cr
   ." Will start garbage collection if below "        #garbage @ .#. cr
   ." This happened " #collect @ u. ." times since starting."     cr cr
   ." At startup, areas have been added as long "                    cr
   ."    as 'unused' did not drop below "          inc-bottom .#. cr cr
   ." This currently amounts to a count of areas of "  #vals @   .#. cr
   ." Sum of memory held in these areas is "           alloc'd   .#. cr
   ." Size of a single area is between 0 and "      max-alloc 1- .#. cr
   ."   |_____________________________       " cr
   ."                   |             |                "
   (  unused | source /old | target /new |  # of runs  )
   (  123456789012)                                          .head   cr
   ." ... key ... "  key drop 12 backspaces ; space

: KEYS         ( -- noend)
               ( ** Evaluate keystrokes)
               key? 
   if          begin  pause  key key? 
               while  drop
               repeat no.busy  case
   #esc     of              0  endof 
   bl       of .head key #esc - endof
   [char] r of rerecs       0= endof
   [char] ? of .help        -1 endof
   [char] h of .help        -1 endof
   [char] l of .head        -1 endof
            cr ." Primes - " .p cr
            .opt 
            .head
             -1 swap endcase
   else                     -1 then ;

: RECVALS      ( -- a u a u 0 // err#)
               ( ** resize one memory area)
               rndadr >R
               R@ val2@ over rndval 
               tuck resize ?dup 0=
   if          swap 2dup   R> val2! 0
   else        R> drop >R 
               2drop 2drop R> then ;

: RECSHOW      ( d a u a u ux -- d uy)
               ( ** show the result of resizing)
                   rec-unused -
   if          no.busy 
               cr  rec-unused vu. 
               2swap swap vu. vu. 
                     swap vu. vu.
               space 2dup $c d[#] space
               ( ticks $7fff and seed !)
   else        2drop 2drop 
               over .busy
   then            rec-unused ;

: RECS         ( --)
               ( ** the loop)
               decs 0=
   if          incs 0=
   if          init  0 #collect !
               0. rec-unused ( d ux)
               .opt  .head
   begin       pause go-on? 
   while       rerecs?  0=
   while       #bottom  @ rec-unused u<
   while       >R 1. d+ recvals R> swap 0=
   while       recshow keys 0= 
   until       then then then then
               drop  no.busy  cr 

               ." ... unlink " #vals @ 0. d[#] 
               de-init alloc'd  decs 0= 
   if          ." memory areas holding "
               0. d[#] ." Bytes."
   else        drop then   cr
               ." Count of runs was "   0  d[#] 
               ." with " #collect @     0. d[#]
               ." garbage collections."
   then then ;

: do-it         0 #vals ! recs bye ;

do-it

