\ cores

\ Some Forth redefinitions for words from ANS Forth Core Extended,
\ Double and String wordsets. As well some common definitions often
\ needed, secondary evaluation of number division, and interpreter
\ number conversion.

\ ** Copyright @ Ewald Pfau, 1991-1994. Fidonet: 2:316/9.0 **

\ Distribution only with the unchanged version of this file
\ at least as a part of what is distributed.

\ -------------------------------------------------------------

: NIP      swap drop ;
: TUCK     swap over ;

: PICK     ?dup if swap >R 1- recurse R> swap else dup then ;
: ROLL     ?dup if swap >R 1- recurse R> swap then ;
: -ROLL    ?dup if rot  >R 1- recurse R> then ;

\ : PICK     dup begin ?dup while rot >R 1- repeat >R dup R>
\            begin ?dup while R> rot rot 1- repeat ;

\ : ROLL     dup begin ?dup while rot >R 1- repeat
\            begin ?dup while R> rot rot 1- repeat ;

\ -------------------------------------------------------------

: WITHIN   over - >R - R> u< ;

: CASE?    over = dup if swap drop then ;

: UMIN     2dup swap u< if swap then drop ;
: UMAX     2dup      u< if swap then drop ;

: LOGBIN   dup  if 0  begin swap 1 rshift
           tuck while 1+ repeat nip then ;

: CASE      0 ;                            immediate
: OF        postpone case?  postpone if ;  immediate
: ENDOF     postpone else ;                immediate
: ENDCASE   postpone drop  begin ?dup while
            postpone then repeat ;         immediate

: DISCARD       ?dup if 0 do drop pause loop then ;
: ALSO          get-order over swap 1+ set-order ;
: PREVIOUS      get-order swap drop 1- set-order ;
: DEFINITIONS   get-order over set-current discard ;

-1 1 rshift negate constant MSB-VAL

: (X<)     if   2drop 2drop -1 exit then -
             if 2drop 0 exit then u< ;

: D=       rot = rot rot = and ;
: D<       rot swap 2dup  < (x<) ;
: DU<      rot swap 2dup u< (x<) ;

: +CY      2dup 0< swap 0< xor if + 0< 0= else drop 0< then ;
: D+       rot + >R  2dup +cy if R> 1+ >R then + R> ;
: DNEGATE  swap negate swap negate over if 1- then ;
: D-       dnegate d+ ;
: DABS     s>d if dnegate then ;

: D2*      over 0< >R  swap 1 lshift swap 1 lshift
           R> if 1 or then ;

: DU2/     dup 1 and >R          swap 1 rshift
           R> if msb-val or then swap 1 rshift ;

: D2/      dup 0< >R du2/ R> if msb-val or then ;

: ^DIV     ( ddiv drem -- d2log ddiv drem)
   2dup    >R >R    0 >R
   begin   2over 2over du<
   while   du2/ R> 1+ >R
   repeat  2drop
   1 0     R@ ?dup if 0 do d2* loop then
   2swap   R> ?dup if 0 do d2* loop then
           R> R> ;

: 2ROT     >R >R 2swap R> R> 2swap ;
: D2PICK   >R >R 2over R> R> 2swap ;

: MU/MOD   ( d u -- u d)
   0       2swap ^div
   0.      >R >R
   begin   d2pick or
   while   2over 2over 2swap du< 0=       ( div =< rem)
      if   2over  d-
           d2pick R> R> d+ >R >R          ( set rem/quot)
      then 2rot du2/ 2rot du2/ 2rot
   repeat  drop >R 2drop 2drop
           R> R> R> ;

: UM/MOD   mu/mod drop ;

: FM/MOD   dup >R
   2dup xor >R >R dabs R@ abs um/mod
   R> 0<   if swap negate swap then
   R> 0<   if      negate over
              if 1- R@ rot - swap
           then then R> drop ;

: SM/REM
   2dup xor >R >R dabs R@ abs um/mod
   R> 0< if      negate      then
   R> 0< if swap negate swap then ;

: /MOD     over 0< swap sm/rem ;
: /        /mod swap drop ;
: MOD      /mod drop ;

: */MOD    >R m* R> sm/rem ;
: *        um* drop ;
: */       */mod swap drop ;

: DUM*          ( d d - q)
   rot 2dup  >R >R >R >R
   2dup      >R >R um*    0
   R> R> R> rot >R um* d+
   R> R>           um* d+ 0
   R> R>           um* d+ ;

: TU/MOD    >R R@ um/mod R> swap >R um/mod R> ;
: TU*       >R swap R@ um* rot R> um* rot 0 d+ ;

: 'T*S      ( d  n  --  +t  sign?)
            2dup xor >R abs >R dabs R> tu* R> 0< ;

: M*/       >R 't*s  R> swap >R tu/mod
            rot drop R> if dnegate then ;

\ -------------------------------------------------------------

: /STRING       ( a u n -- a+ u-)
            >R    R@        0<
   if       over  R@ abs    u<
      if    + 0   swap      R> drop exit
      then  R@ -  swap R> + swap  exit
   then     dup   R@        u<
      if    + 0             R> drop exit
      then  R@ -  swap R> + swap ;

: SKIP          ( a n char -- a+ n-)
   >R  begin dup     while over c@  R@ =
   while 1 /string   repeat then    R> drop ;

: SCAN          ( a n char -- a+ n-)
   >R  begin dup     while over c@  R@ -
   while 1 /string   repeat then    R> drop ;

: -SKIP         ( a0 n char -- a0 n-)
   >R begin dup while 1-
   2dup + c@ R@ - until 1+ then R> drop ;

: -SCAN         ( a0 n char -- a0 n-)
   >R begin dup while 1-
   2dup + c@ R@ = until 1+ then R> drop ;

: CMOVE         ( a0 a1 n --)
   ?dup if 0 do over i + c@ over i + c!
   loop then 2drop ;

: CMOVE>        ( a0 a1 n --)
   ?dup if >R R@ +  swap R@ + swap R>
   0 do 1 - swap   1 - swap
   over c@ over c! loop then 2drop ;

create LOWERS  here
132 c, 148 c, 129 c, 130 c, 145 c, 134 c, 135 c, 164 c,
               here swap -
constant #ECAPS

     create UPPERS
142 c, 153 c, 154 c, 144 c, 146 c, 143 c, 128 c, 165 c,

: >UPPER   ( b -- b)          dup lowers #ecaps rot
   scan if nip lowers - uppers + c@ else drop then ;

: >LOWER    ( b -- b)         dup uppers #ecaps rot
   scan if nip uppers - lowers + c@ else drop then ;

: CAPITAL  ( b -- b)
   dup  97 u< if         exit then
   dup 123 u< if  32 xor exit then
   dup 128 u< if exit         then  >upper ;

: UPPER  ( a n --)         ?dup if 0 do
   dup c@ capital over c! char+ loop then drop ;

: -CAPITAL  ( b -- b)
   dup  65 u< if         exit then
   dup  91 u< if  32 xor exit then
   dup 128 u< if         exit then  >lower ;

\ -------------------------------------------------------------

variable CAPS  -1 caps !

: 2CC@    ( a a -- b b)
          c@ swap c@      caps @
          if capital swap capital
          else       swap then ;

: U<=>    ( u1 u2 -- -1/0/1)
          2dup = if 2drop 0 exit then
          u<     if      -1 exit then 1 ;

: COMPARE       ( a n a n -- f)
   rot swap     2dup u<=> >R umin
   ?dup if 0 do 2dup 2cc@    u<=>
      ?dup if   unloop R> drop
                nip nip     exit
      then      1+ swap 1+ swap
   loop then    2drop R> ;

: CAPS-SCAN   ( a n b -- a+ n-)    caps @ if
   >R 2dup   R@  capital scan
      2swap  R> -capital scan   rot 2dup
      u< if nip nip       exit
      then  drop rot drop exit      then scan ;

: SEARCH    ( a1 n1 a2 n2 -- a3 n3 f)
        ?dup 0= if drop -1 exit then  2>R
   dup R@       u< if 2R> 2drop 0 exit then 2dup
   begin        2R@
      0 do      dup >R c@ caps-scan
      dup 0= if R> drop unloop
                2R> 2drop 2drop 0 exit
         then   1 /string R> 1+
      loop      drop
                R@ negate /string over
                2R@ tuck compare
   while        1 /string
   repeat       2swap 2R> 2drop 2drop -1 ;

\ -------------------------------------------------------------

: FIXBASE?     ( b  --  base  0/-1)
   dup [char] $ = if drop 16 -1 exit then
   dup [char] & = if drop 10 -1 exit then
       [char] % = if       2 -1 exit then base @ 0 ;

: NUM-CLASS    ( a n -- a+ n-  f:neg / set base)
   dup 0= if 0 exit then
   over c@  [char] - =  dup >R         abs /string
   over c@ fixbase?     swap base !    abs /string R@ 0= if
   over c@  [char] - =  R> drop dup >R abs /string then R> ;

: PUNCT?       ( b - f)   dup [char] . =
   over [char] , = or    swap [char] / = or ;

: TO-NUMBER    ( a n f:neg  --  d dpl #?)
   over 0= if 0 exit then
   rot rot  over >R  2dup + >R  0. 2swap
   begin  >number over c@ punct? over and
   while  over R> drop R> 1+ >R  >R 1 /string
   repeat >R >R rot if dnegate then R> R>
   over R> - 1- rot R> = 0= rot 0= and ;

: NUMBER?      ( a n -- d 2 // n 1 // 0)
   base @ >R  num-class  to-number  R> base !
   if   \ dup dpl ! ( old F83)
   0<   if drop 1 exit then
                2 exit then drop 2drop 0 ;

