\ The March '92 issue of Embedded Systems Programming has an
\ article called "Objects for Small Systems" by myself.  The
\ article describes an object-oriented programming system
\ implemented in the draft-proposed ANS Forth standard.
\ Unfortunately, the source code was not printed with the article.
\ The code is sufficiently short that I have included it in this
\ posting.  The code requires the Core and Search Order word
\ sets plus some odds and ends from the Core Extensions (:NONAME
\ and COMPILE, ).  The only area in which the code does not
\ conform to the standard is in being lower case; you will have to
\ translate to upper case before running it.
\ The original code is contained in two files. These are delimited
\ by the comments containing a "cut here" message.  Have fun.

\ John R. Hayes   john@aplcomm.jhuapl.edu
\ Applied Physics Laboratory  Johns Hopkins University

\ Object Oriented Programming System, Version 3.1,
\ dpANS (October, 1991)

marker nooof
hex
2 9 thru
decimal

                                        hex
: STRUCTURE ( -- pfa template)          create here 0 , 0
   does>    ( -- size)                  @ ;
: AUS:      ( offset size --- offset')  create over , +
   does>    ( base -- base')            @ + ;

: CHARS:    chars aus: ;
: CHAR:     1 chars: ;
: CELLS:    cells >R aligned R> aus: ;
: CELL:     1 cells: ;
: STRUCT:   >R aligned R> aus: ;

: ENDSTRUCTURE   ( pfa template --)  aligned swap ! ;
: MAKESTRUCT     ( size --)          create allot ;

\ Structure of class

structure class-structure
   cell: .PARENT   \ pointer to parent class
   cell: .VOCAB    \ cfa of local vocabulary
   cell: .SIZE     \ size (in aus) of instance region
   cell: .NMSGS    \ number of messages accepted by class
                   \ method vectors are appended here
endstructure

\ Run-time Object Management

variable CURRENT-OBJECT
: SELF    ( --- object)                current-object @ ;
: SELF+   ( offset --- object+offset)  current-object @ + ;

\ Define messages accepted by a particular class hierarchy.

: MESSAGES>   ( -- addr[nmsgs] nmsgs)
   create here 0 dup ,
   does> @ ;   ( -- nmsgs)

: ENDMESSAGES>  swap ! ;

: MSG:     ( n -- n')
   create dup cells class-structure + , 1+
   does>   ( object --)
           over current-object
                    dup @ >R !
           @ ( n+) swap @ ( class) +
           @ ( method)  execute
           R>   current-object ! ;

\ Define class hierarchy constructors.

variable CURRENT-CLASS

: PUSH-VOCABS  ( <order> class -- <order>')
   ?dup if dup >R .parent @ recurse R> .vocab @ swap 1+ then ;

: DEFAULT-METHOD  ( --)
   ." method undefined" abort ;

\ Define class hierarchy constructors.

: CONSTRUCT-CLASS  ( nmsgs size-of-object parent --)
   wordlist
   create here dup >R current-class !
   class-structure allot
   R@ .vocab !  R@    .parent !
   R@ .size  !  dup R> .nmsgs !
   0 do ['] default-method  , loop
   get-order current-class @ push-vocabs
   over set-current set-order ;

\ Define class hierarchy constructors.

: CLASS>  ( nmsgs --)
   0 0 construct-class ;

: SUB-CLASS>  ( class --)
   dup >R .nmsgs @  R@ .size @  R@  construct-class
   R@ class-structure +  current-class @ class-structure +
   R> .nmsgs @ cells move ;

: END>  ( --)
   get-order current-class @
   begin >R nip 1- R> .parent @ dup 0= until
   drop over set-current set-order ;

\ Local variables

variable TO?
: TO:  true to? ! ; immediate

: LOCAL:  ( --)
   create current-class @ .size
          dup @ dup ,   cell+ swap ! immediate
   does>  ( addr[offset] --)
      @ cell+    postpone literal
                 postpone self+
      to? @ if   postpone !  false to? !
            else postpone @  then ;

\ Methods

: GET-BODY   ( -- x)
   bl word find 0= abort" unknown message" >body @ ;

: SUPER  ( --)
   current-class @ .parent @ get-body + @ compile, ; immediate

: METHOD:  ( -- addr[slot] xt colon-sys)
   get-body current-class @ + :noname ;

: ;METHOD   ( addr[slot] xt colon-sys --)
   postpone ; swap ! ; immediate

: NEW   ( class -- object)
   here >R dup .size @ cell+ allot R@ ! R> ;


\ ==============================================================
\ Documentation

\ Structure access words usage:
\ structure foo         \ Declare a structure
\      3 chars: .part1  \  consisting of a 3 char part,
\  cell: .part2         \  a one cell part,
\  char: .part3         \  and a one char part.
\ endstructure
\
\ structure foobar      \ Declare another structure
\      2 cells: .this   \  consisting of two cells,
\   foo struct: .that   \  and substructure
\ endstructure
\
\ create teststruct foobar allot \ Allocate a structure instance
\ 123 teststruct .that .part2 !  \ and store something in it.

\ Object Oriented Programming System, Version 3.1,
\ dpANS (October, 1991)

\ Implementation notes:
\ 1. Structure instances must be placed at an
\ aligned address (i.e. via create)
\ 2. endstructure pads out the end of the structure.
\ This is unnecessary

\ Structure of class

\ : STRUCTURE  \ Start structure declaration.

\ : AUS:       \ Structure member compiler.
\    does>     \ Add member's offset to base.

\ : CHARS:     \ Create n char member.
\ : CHAR:      \ Create 1 char member.
\ : CELLS:     \ Create n cell member.
\ : CELL:      \ Create 1 cell member.
\ : STRUCT:    \ Create member of given size.

\ : ENDSTRUCTURE
\ : MAKESTRUCT \ allocate memory for a struct of given size

\ \ Structure of class

\ structure class-structure
\    cell: .PARENT   \ pointer to parent class
\    cell: .VOCAB    \ cfa of local vocabulary
\    cell: .SIZE     \ size (in aus) of instance region
\    cell: .NMSGS    \ number of messages accepted by class
\                    \ method vectors are appended here
\ endstructure

\ \ Run-time Object Management
\ variable CURRENT-OBJECT   \ current object
\ : SELF    \ Copy current object to parameter stack.
\ : SELF+   \ Index instance variable.

\ \ Define class hierarchy constructors.

\ : MESSAGES>
\    does>
\ : ENDMESSAGES>

\ : MSG:     \ Create message n.
\    does>   \ Call method n for given object.
\            \ save current object
\            \ set new current object
\            \ fetch vector from class and execute
\            \ restore original 'current' object
\       current-object @ >R
\       @ >R  dup current-object !
\       @ R> + @ execute
\       R> current-object ! ;
\ \ Define class hierarchy constructors.

\ variable CURRENT-CLASS  \ class currently being defined

\ : PUSH-VOCABS
\    \ Add any parent wordlists to the search order on the stack
\    \ then add the wordlist belonging to the given class.

\ : DEFAULT-METHOD
\    \ This is executed if an object receives a message
\    \ for which there is no defined method.

\ \ Define class hierarchy constructors.

\ : CONSTRUCT-CLASS
\    \ build a class data structure with the given parameters,
\    \ fill with null execution vectors, create naming wordlist,
\    \ and modify search order.
\    \ create wordlist
\    \ name class; record address
\    \ allocate class structure
\    \ fill in wordlist, parent
\    \ fill in size and number of msgs
\    \ fill in default methods
\    \ defs in new wordlist

\ \ Define class hierarchy constructors.

\ : CLASS>  \ Create a new class hiearchy.

\ : SUB-CLASS>
\    \ Create a subclass of the given class.
\    \ The subclass inherits the parents' methods and instance
\    \ variables.

\ : END>
\    \ Complete class definition by restoring search order.

\ \ Local variables

\ variable TO?
\ : TO  true to? ! ; immediate

\ : LOCAL:
\           \ Create an instance variable for current class.

\    does>  \ Compile fetch or store of instance.

\ \ Methods

\ : GET-BODY  \ Look up the next word in the input stream, and
\             \ extract its body.  It must have been 'create'd.

\ : SUPER     \ Convert the next message to the self object
\             \ into a subroutine call.

\ : METHOD:   \ Define a method to correspond with message
\             \ indicated in input stream.

\ : ;METHOD   \ Complete compilation of method.
\             \ Allocate an object of type class.
\             \ allot object + class pointer

\ : NEW       \ init class pointer
