marker nosplit

2 20 thru

\ [ PAD UNUSED ] is scratch-area for copying

: APPEND        ( a> n >a n -- a n+)
   2over 2over + swap move rot + rot drop ;

\ : UMIN 2dup u< if drop else nip then ;

: PRMSDROP     ( d d d # n n n -- #)
               drop 2drop >R 2drop 2drop 2drop R> ;

: FILE-CUT     ( d-pos d-len hdl buf n -- #)
   2>R >R      2over d+ R@ file-size ?dup
                     if R> 2R> prmsdrop exit then

   begin       2over 2over du<  ( pos/w pos/r size)
   while       2swap 2dup R@ reposition-file ?dup
                     if R> 2R> prmsdrop exit then
               R> 2R@ rot dup >R read-file ?dup
                     if nip R> 2R> prmsdrop exit then
               >R R@ 0 d+ 2swap 2rot ( pos/r size pos/w)
               2dup R> rot rot R@ reposition-file ?dup
                     if nip R> 2R> prmsdrop exit then
               dup >R 0 d+ R> R> 2R@ drop
               rot rot dup >R write-file ?dup
                     if R> 2R> prmsdrop exit then
               2rot 2rot
   repeat      2drop 2drop R> 2R> 2drop resize-file ;

: FILE-INSERT  ( d-pos d-len hdl buf n -- #)
   2>R >R     R@ file-size  ?dup
                     if R> 2R> prmsdrop exit then
               2swap 2over d+
               2dup R@ resize-file ?dup
                     if R> 2R> prmsdrop exit then
               2rot 2rot
   begin       2over 2over du<  ( pos/w pos0 pos/r)
   while       2over 2over 2swap d-
               R> 2R@ nip swap >R ( n) 0
               2over 2over du< 0=
               if 2swap then 2drop

               ( .. pos/r diff) 2swap 2over d-
               2dup R@ reposition-file ?dup
                     if nip nip R> 2R> prmsdrop exit then
               2swap drop R> 2R@ drop rot rot
               dup >R read-file ?dup
                     if nip  R> 2R> prmsdrop exit then
               >R 2rot R@ 0 d-  ( pos0 pos/r pos/w)
               2dup R> rot rot R@ reposition-file ?dup
                     if nip  R> 2R> prmsdrop exit then
               R> 2R@ drop rot rot
               dup >R write-file ?dup
                     if  R> 2R> prmsdrop exit then
               2rot 2rot
   repeat      R> drop 2R> 2drop 2drop 2drop 2drop 0 ;
( ------------------------------------------------------------)

: PRMS-DROP1     ( d d # n n -- #)
   2drop nip nip nip nip ;

: SHUFFLE-BLOCK  ( hdl> >hdl buf n -- #)
   2swap >R >R R@ file-position ?dup
         if 2R> prms-drop1 exit then
   2swap over swap R@ read-file ?dup
         if nip 2R> prms-drop1 exit then
   tuck R> R> swap >R write-file ?dup
         if R> drop >R drop 2drop R> exit then
   >R 2dup R> 0 R@ pad unused $7fff umin file-cut ?dup
         if R> drop >R 2drop R> exit then
   R> reposition-file ;

$7fff constant MAXBLOCK

: SHUFFLE      ( d-rest hdl> >hdl -- #)
   2swap          unused maxblock umin
             um/mod swap >R ?dup
   if 0 do   2dup unused maxblock umin
                pad swap shuffle-block ?dup
             if unloop nip nip R> drop exit then
   loop then R> pad swap shuffle-block ;

: LINE-SKIP    ( hdl -- d+ #)
   dup >R file-position
       ?dup if R> drop exit then
   pad 255 tuck R@ read-line
       ?dup if R> drop nip nip nip exit then
   rot rot = and
   if    R> reposition-file 0. rot exit
   then  R> file-position >R 2swap d- R> ;

: LINES-SKIP    ( hdl -- d-diff+ #)
            dup >R file-position
                ?dup if R> drop exit then
   begin    pad 255 R@ read-line
                ?dup if R> drop nip nip exit then
   while    0=
   until    R> file-position >R 2swap d- R> exit
   then     drop R@ reposition-file
                ?dup if R> drop exit then
            R> line-skip ;

: SPLIT-FILE    ( d hdl> >hdl -- #)
         >R >R R@ file-size
            ?dup if 2R> prms-drop1 exit then
         2over 2over du<
   if    2over R@ reposition-file
            ?dup if 2R> prms-drop1 exit then
        R@ lines-skip
            ?dup if nip nip 2R> prms-drop1 exit then
        d+ 2swap d- R> R> shuffle exit
   then 0 2R> prms-drop1 ;

: JOIN-FILE     ( hdl> >hdl -- #)
   2>R R@ file-size
       ?dup if 2R> 2drop nip nip exit then
   R@ reposition-file
       ?dup if 2R> 2drop exit then
   2R@ drop  file-size
       ?dup if 2R> 2drop nip nip exit then
   2R> shuffle ;

32 value MAXTRIES

: FREAD-FILE    ( a n hdl -- n #)
           0. rot  maxtries 0
   do      >R   2drop
           2dup R@ read-file
           R>   over 0= if leave then
   loop    drop 2swap 2drop ;

: COPY-ONE      ( hdl> >hdl buf n -- #)
   2swap >R >R             over swap R> fread-file
   ?dup if R> drop nip nip exit then R> write-file ;

: COPY-FILE     ( hdl> >hdl buf n -- #)
   2>R over header-read nip
       ?dup if 2R> 2drop nip nip exit then
   dup header-write
       ?dup if 2R> 2drop nip nip exit then
   over dup >R file-size
       ?dup if R> drop 2R> prms-drop1 exit then
   0. R> reposition-file
       ?dup if 2R> prms-drop1 exit then
   R@ um/mod 2R> 2swap swap >R ?dup
   if 0 do  2over 2over copy-one
       ?dup if unloop nip nip nip nip exit then
   loop then drop R> copy-one ;

: WHAT
." <name/from=cut>   <name/to=new>      d/cut-size  SPLIT " cr
." <name/2nd>        <name/1st=target>              JOIN  " cr
." <name/from>       <name/to=new>                  FCOPY " cr
." <drive/from>      <drive/to>         FFRESHEN  " cr
." <drive/from>      <drive/to>         FUPDATE   " cr
." <drive/from>      <drive/to>         XCOPY     " cr ;

: OPEN&CREATE   ( a n a n -- hdl hdl #)
   2swap   r/w open-file
       ?dup if 2swap 2drop 0 swap exit then
   rot rot r/w create-file
        dup if rot close-file rot rot then ;

: OPEN&OPEN     ( a n a n -- hdl hdl #)
   2swap   r/w open-file
       ?dup if 2swap 2drop 0 swap exit then
   rot rot r/w open-file
        dup if rot close-file rot rot then ;

: ?CLOSE&CLOSE  ( # hdl hdl --)
   close-file swap close-file rot throw throw throw ;

: SPLIT         ( a n  a n  d --)
   2rot 2rot open&create throw 2>R
   2R@ split-file  2R> ?close&close ;

: JOIN         ( a n  a n  --)
   open&open throw 2>R
   2R@ join-file 2R> ?close&close ;

: 'FCOPY       ( a n a n buf n --)
   2rot 2rot open&create throw 2>R
   2R@ 2swap copy-file  2R> ?close&close ;

: FCOPY        ( a n a n --)
   pad unused 'fcopy ;

: T&D-COMP     ( ss...yy  ss...yy -- -1/0/1)
   2rot 2>R 2swap 2>R
       rot swap u<=> ?dup if nip nip nip nip nip
                             nip 2R> 2drop 2R> 2drop exit then
                u<=> ?dup if nip nip nip nip
                                 2R> 2drop 2R> 2drop exit then
   2R> rot swap u<=> ?dup if nip nip nip
                                 nip 2R> 2drop       exit then
                u<=> ?dup if nip nip 2R> 2drop       exit then
   2R> rot swap u<=> ?dup if                 nip nip exit then
                u<=> ;

: ONEDIR-COMP   ( dir dir -- -1/0/1)
   2dup >fname count rot >fname count
   compare if 2drop 0 exit then
   >R >ftime&date  R> >ftime&date t&d-comp
   ?dup 0= if -1 then ;

: DIR-COMP      ( dir a n -- -1/0/1 #)
            d/o open-dir ?dup
            if nip exit then >R
   begin    R@ read-dir 0=
   while    over swap onedir-comp ?dup
   until    else  drop 0
   then     nip R> close-dir ;

: COPY-NAMES    ( a/dir n a/dir n a n -- a n a n)
   2rot pad 0 append 2over 2swap append 2swap
   2rot pad 256 + 0 append append
   2dup type cr ;

: COPY-SCAN     ( a n a n dir-a mthd -- a n a n err#)
   >R   dup 2over dir-comp ?dup
        if nip nip R> drop exit then
        ( f) R> execute ( 'f)
   if   >R 2over 2over R>
        >fname count copy-names
        ['] fcopy catch exit
   then drop 0 ;

:noname     create ,
   DOES>    ( a n a n --)
   @ >R     2over d/o open-dir throw >R
   begin    R@ read-dir 0=
   while    2R@ drop copy-scan ?dup
            if 2R> nip close-dir drop throw exit then
   repeat   drop 2drop 2drop
            2R> nip close-dir throw ;

      ' 0>         over execute FFRESHEN
:noname 0< 0= ;    over execute FUPDATE
:noname drop -1 ;  swap execute XCOPY

