\ Written by Ewald Pfau @ 2:316/9@fidonet, Sep/1993

\ Distribution only with the unchanged version of this file
\ at least as a part of what is distributed.

\ check for:       COUNT takes char-width length-value
\ provide for:     scrt-in ( ! at start-up !)

\ path>   <default tokenname of path   for following $fspec>
\ ending> <default tokenname of ending for following $fspec>
\ cfg-on ... $fspec <tokenname> ... $val <tokenname> ... cfg-off

\ s" <filename>" $to cfgfile      <char> $option cfgfile
\ s" <filename>" $to logfile      <char> $option logfile
\ s" <pathname>" $to tmppath      <char> $option tmppath
\ s" <apps-name>" $to logshort
\ s" <presentation>" $to loglong
\ <char>    $option <tokenname of $val/$fspec>
\ <char> set-option <tokenname of method>
\ set-order, then execute command-line:   esc-catch   cmd-catch

\ ------------------------------------------------------------

         decimal -1 set-order definitions also editor also

\ ------------------------------------------------------------

           marker nouft

  2 load  scrt-in
         decimal -1 set-order definitions

\ some file access and string words in editor wordlist
\ uncomment definitions herein if not

  3  21 thru   ( wordlists, numbers & strings)
 22  28 thru   ( allocation & inputstream)
 29  43 thru   ( dirc, filespecs & commandline)

  44  50 thru   ( logfile interface)
  51  57 thru   ( indexing interface)
  58  68 thru   ( macro-interpret)

\    wordlist constant CMD-WID
\    cfg-off  $val     CFGFILE

\    char C    $option  cfgfile
\    s" ram1_" $to      tmppath

\ - Wordlists, numbers & strings ------------------------------

\ +ORDER >ORDER >> add to, replace in search-order.
\ XCREATE       >> create in given wordlist.
\ LOGBIN        >> calc binary logarithm.
\ MU* MS* MU/MOD MS/REM >> Double-cell operators.
\ U<=> DU<=> QU<=>  >> compare for below, same or above.
\ DATE>ID       >> Given time&date, make a double-cell value.

\ $>#?          >> Conversion string to number.
\ REPL-CHARS    >> Replace in string.
\ SPLIT         >> Find delimiter and split string.
\ LEX           >> Split by char out of group of delimiters.
\ #FIELD        >> N'th char-delimited field in string-record.
\ INSERT        >> Insert, replace or append.
\ INS-LIMIT     >> Check for secure operation of INSERT.

: XCREATE       ( wid --)
   get-current      swap set-current
   public create ( private) set-current ;

: >ORDER        ( wid --)
   >R get-order nip R> swap set-order ;

: +ORDER        ( wid --)
   >R get-order R> swap  1+ set-order ;

: $ALLOC        ( a n -- )
   dup c, here over allot swap move ;

char - constant '-'
char , constant ','
char ; constant ';'
char . constant '.'
char : constant ':'
char / constant '/'
char \ constant '\'
char % constant '%'
char * constant '*'
char ' constant '''
char > constant '>'
char < constant '<'
char = constant '='
char _ constant '_'

  13   constant #CR
  26   constant #EOF
   1   constant D/O

: NOPE ;

\ : CASE?     over = if drop -1 else 0 then ;
\ : UMIN      2dup swap u< if swap then drop ;
\ : UMAX      2dup      u< if swap then drop ;

: LOGBIN        ( u -- n)
   dup if 0 begin  swap 1 rshift
   tuck while 1+ repeat nip then ;

     4 constant 4
: 4DROP     2drop 2drop ;
: 4DUP      2over 2over ;
: 4SWAP     2>R 2rot 2rot     2R> 2rot 2rot ;
: 4!        >R R@ 2! R> 2 cells + 2! ;
: 4@        dup 2 cells + 2@ rot 2@ ;

    3 constant 3
: 3DROP     drop 2drop ;
: 3DUP      dup 2over rot ;
: 3SWAP     2rot 2>R 2>R swap 2R> rot 2R> rot ;
: 3@        dup cell+ 2@ rot @ ;
: 3!        dup >R ! R> cell+ 2! ;

\ : U<=>          ( u u -- -1/0/1)
\    2dup  =  if 2drop 0 exit then
\          u< ?dup 0= if 1 then ;

: DU<=>         ( d d -- -1/0/1)
   2over 2over d=  if 2drop 2drop 0 exit then
               du< ?dup 0= if 1 then ;

: QU<=>         ( q q -- -1/0/1)
   2rot 2swap du<=>
   ?dup if >R 2drop 2drop R> exit then du<=> ;

: Q=        2rot d= >R d= R> and ;
: 4NIP      2rot 2drop 2rot 2drop ;

: MU*      ( d u -- d)
   >R swap R@ um* rot R> um* drop + ;

: MS*      ( d n -- d)
   2dup xor 0< >R abs >R dabs
   R> mu* R> if dnegate then ;

: MU/MOD   ( d n -- n d)
   >R 0 R@ um/mod R> swap >R um/mod R> ;

: MS/REM   ( d n -- n d)
   2dup xor >R >R dabs R@ abs mu/mod
   R> 0< if 2>R negate 2R> then
   R> 0< if    dnegate     then ;

: DSHIFT+       ( d u n -- d)
   2dup lshift [ -1 logbin 1+ ] literal
   rot - rot swap rshift rot or >R or R> ;

: DATE>ID       ( ss mm hh dd mm yy -- d)
   0. rot       dup 1900 u< 0= if 1900 - then
                dup   80 u< 0= if   80 - then
       63 and 26 dshift+        rot 15 and 22 dshift+
   rot 31 and 17 dshift+        rot 31 and 12 dshift+
   rot 63 and  6 dshift+        rot 63 and  0 dshift+ ;

                ( a n b -- a n)
\ : SKIP         >R  begin dup     while over c@  R@ =
\                while 1 /string   repeat then    R> drop ;

\ : SCAN         >R  begin dup     while over c@  R@ -
\                while 1 /string   repeat then    R> drop ;

\ : -SKIP         >R begin dup while 1-
\                2dup + c@ R@ - until 1+ then R> drop ;

\ : -SCAN         >R begin dup while 1-
\                2dup + c@ R@ = until 1+ then R> drop ;

: PLACE         ( a n $a --)
   2dup c! 1+ swap move ;

: APPEND        ( a> n >a n -- a n+)
   2over 2over + swap move rot + rot drop ;

: APPEND>       ( >a n a> n -- a n+)
   2over + >R tuck R> swap move + ;

: ADD-CHAR      ( c a n -- a n+)
   2dup + >R  rot R> c! 1+ ;

: ADD-CHAR>     ( a n c -- a n+)
   >R 2dup + R> swap c! 1+ ;

: SPLIT         ( a0 n b -- a0 n a1 n/0)
   >R 2dup R> scan dup
   if rot over - rot rot 1 /string then ;

: REPL-CHARS    ( a n b b --)
   swap     >R rot rot
   begin    R@ scan dup
   while    >R 2dup c! R> 1 /string
   repeat   2drop R> 2drop ;

: CHAR>$        ( c -- a n)  0. <# rot hold #> ;

: CHARS>$       ( cx..c1 x -- a n)
   0. <# rot ?dup if 0 do rot hold loop then #> ;

: INSERT        ( a1n1 a2n2 a3n3 -- a1n[1-2+3])
                ( a2n2 within a1n1, by a3n3)
                ( Append if a2=[a1+n1] and n2=0)

   swap >R >R         ( a1 n1 a2 n2)
   rot   over -       ( a1 a2 n2 n1-2)
   2over swap -       ( a1 a2 n2 n1-2 a2-1)
   over  swap -       ( a1 a2 n2 n1-2 nrest)
   2swap over +       ( a1 n1-2 nrest a2 a2+n2)
   swap R@   over +   ( a1 n1-2 nrest a2+n2 a2 a2+n3)
   swap >R   rot move ( a1 n1-2 /R: a3 n3 a2)
   R> R@ rot + swap   ( a1 n1-n2+n3 a2)
   R> R> rot rot move ;

: INS-FITS?     ( a1 n1 a2 n2 -- f)
                ( ** check for an1/an2 valid for insert)
                ( ** [ a1 =< a2 ], [ a1+n1 >= a2+n2 ])
                rot 2over           swap u< 0= >R
                rot rot + rot rot + swap u< 0= R> and ;

: INS-LIMIT     ( a1n1 a2n2 a3n3 max -- a1n'1 a2n2 a3n'3)
                ( ** an2 within an1 ; n1 =< max)
                ( ** cut trailing end if insertion overflow)
                ( ** first cut an1 elsewise also an3)

                rot rot 2>R >R
                2over nip R@ swap - over +
                R> over R@ u<

   if           ( an1 an2 [max-n1+n2] max /R: an3)
                >R >R
                2over 2over + rot rot + =
      if        ( a2n2 trailing)
                R> R>  drop  2R> drop swap
      else      R>     drop
                2over 2over drop nip
                R@ rot + swap -         ( 'n3= max+a1-a2)
                R> swap 2R> rot umin    ( an1 an2 max an3)
                tuck 2>R -
                over + >R  rot drop     ( 'n1= max+n2-n3)
                R> rot rot     2R>
   then else    2drop 2R> then  ;

: #FIELD        ( a n c # -- a+ n- -1 // 0)
                ( ** '#'=0 >> field is the whole record)
                ( ** 1st field is ahead of 1st delimiter 'c')
                ( ** Last field is behind last delimiter)
                ( ** Groups of blanks count for one delimiter)
                ( ** Elsewise empty fields between)
                ( ** For '#'>=2 >> Return false if no field)

   ?dup 0=      if drop -1 exit then 1- ?dup
   if 0 do      >R R@ scan ?dup 0=
      if        R> 2drop unloop 0 exit
      then      R@ bl = if R@ skip else 1 /string then R>
   loop then    >R over swap R> scan drop over - -1 ;

: LEX   ( a1n1/string a2n2/chars
             -- a3n3 a1n4 a5/char -1 // a1n1 0)
        ( adr-of-char from 2 in 1, trailing 3, leading 4)
                2over drop  0 >R 0 2>R
   begin        dup
   while        2over 2over drop c@ scan dup
      if        2R> rot 2dup u<
         if     nip nip 2over R> 2drop >R
         else   drop rot drop    then  2>R
      else      2drop then  1 /string
   repeat       2drop       2R> ?dup
      if        dup   >R    1 /string
                2swap R> -  R> -1
      else      R> 2drop    0 then ;

: $>#?          ( a n -- # -1 // 0)
                ( ** f >> not-empty & no-rest)
                dup
   if           over c@ '-' = dup >R
                if 1 /string then dup
      if        0. 2swap >number
                nip nip R>
                if swap negate swap then
                \ if drop 0 else -1 then exit
                0= ?dup nip exit
      then      R> drop
   then         2drop 0 ;

:noname         create
   DOES>        ( n -- a n)
                count rot 1- dup dup + + umin + 3 ;

            s" JanFebMarAprMayJunJulAugSepOctNovDec???"
rot execute >MONTH$ here
            over 3 - 2swap $alloc swap c! align

: $>MONTH       ( a -- n/0)
   1 12 0 do    2dup >month$
                rot over compare 0=
      if        nip unloop exit
      then      1+
   loop         2drop 0 ;

: MONTH$-HOLD   ( n -- // "_mmm")
   >month$   tuck + swap 0
   do 1- dup c@ hold loop bl hold drop ;

: ##B-HOLD      ( n b -- // "b##")
   swap 0 # # rot hold 2drop ;

: TIME>PAD    ( ss mm hh --  // "_hh:mm:ss")
   swap rot     ':' ##b-hold
   ':' ##b-hold  bl ##b-hold ;

: 2$>#          ( a -- n)
   0. rot 2 >number 2drop drop ;

( - allocation & inputstream ----------------------------------

 SCRT-IN     >> Initialize buffers at startup!
 SCRT-AREA   >> Define one scratch area. Allocation at runtime.
 UP-LINK-IN  >> Given an anchor, link upwards from there.

 GET-LINE    >> Read a line in a file.
 CAPITAL     >> Capitalize a letter.
 WORD-IN     >> Parse from input, skip blanks.
 NO$         >> Empty string, default for string values.
 $ALLOC      >> Allocate a counted string.
                Make sure, COUNT works else redefine it.
 $=          >> Allocate a string constant.

 '$VAL       >> Define an empty string value.
 $TO         >> Allocate a string, fill string value. )

    variable SCRT-LINK

: 'SCRT-ADD     ( n a -- n+ a)
   dup cell+ @ rot + swap ;

: SCRT-IN       ( --)
   0        scrt-link
   begin    @ ?dup
   while    'scrt-add
   repeat   dup allocate throw dup rot 0 fill
            scrt-link
   begin    @ ?dup
   while    2dup 1 cells - ! 'scrt-add
   repeat   drop ;

: UP-LINK-IN    ( a --)
   begin dup @ ?dup while nip repeat here swap ! 0 , ;

: SCRT-AREA     ( n --)
                aligned create 0 , scrt-link up-link-in ,
   DOES>        ( -- a)    @ ;

  255 constant LINESIZE
  linesize 1+ 1+ 1+ scrt-area PATHSCRT
  linesize 1+ 1+ 1+ scrt-area LOGSCRT
  linesize 1+ 1+ 1+ scrt-area LINESCRT
  linesize 1+ 1+ 1+ scrt-area RENSCRT

: GET-LINE      ( hdl -- a n -1 // 0)
   >R linescrt dup linesize
   R> read-line throw
   if -1 exit then 2drop 0 ;

: IS-LINE?      ( a n -- a n -1 // 0)
   #eof -skip over c@ ';' = over 0= or
   if 2drop 0 exit then -1 ;

: >RENSCRT      ( a n -- a n)
   renscrt place renscrt count ;

: WORD-IN       ( -- a n)
   begin bl parse bl skip ?dup if exit then
   source nip >in @ - while drop repeat 0 ;

: /SOURCE       ( -- a n)   source >in @ /string ;
: /LINE         ( -- a n)   /source bl skip -trailing ;
: PICK-LINE     ( -- a n)   /line postpone \ ;

:noname         create
   DOES>        ( b -- b)
   over swap 2@ within if 32 xor then ;

execute 'CAPITAL   char a , char z 1+ ,

here 0 c, align constant NO$

: $=            ( --)           create $alloc align
   DOES>        ( -- a n)       count ;

: '$VAL         ( a n --)       create no$ ,
   DOES>        ( -- a n)       @ count ;

: '$TO          ( a n a --)     here swap ! $alloc align ;

: $TO           ( a n --)
        ' >body  state @
   if   postpone literal
        postpone '$to exit
   then          '$to ;         immediate

: $TO?          ( a n cfa f --)
   if >body '$to exit then drop 2drop ;

( - filespecs & commandline ----------------------------------

 DIRC       >> Show directory
 CMD-CATCH  >> Execute commands given in commandline via CATCH.
 $OPTION    >> Make a string value patchable via commandline.
 CMD-OPTION >> Make an operation callable via cmdline-switch.
 ESC-CATCH  >> Execute switches and patches from commandline.

 $VAL       >> Create a string value
               When defined, string values are empty.
 ENDING>    >> Keep token of string for filename ending.
 PATH>      >> Keep token of string for pathname. For this:
 $FSPEC     >> Create a string value for a file spec, which
               will be composed of path, string, and ending.
 CFG-ON ... >> Make $VAL & $FSPEC patchable via cfg-file, by
 ... CFG-OFF | same name; ignored if patched via commandline. )

    wordlist constant CFG-WID

                    get-current cfg-wid set-current
: (             postpone ( ; immediate
: \             postpone \ ; immediate
                                        set-current

: SAME/MIN      ( a n a n -- f)
                >R over R> swap u<
      if        drop 2drop 0 exit
      then      over compare 0= ;

: DIR/SAME      ( a n a n -- #flast/0)
   1 begin >R   2over '_' R@ #field
   while        2over '_' R@ #field
   while        same/min
   while        R> 1+
   repeat       else 2drop
   then         2drop 2drop R> drop 0 exit
   then         2swap + 1- c@ '_' =
   if           2drop R> 1- exit
   then         '_' R@ #field
   if           2drop R> drop 0 exit
   then         R> 1- ;

: DIREND-OPEN   ( a0 n -- a0 n- a+ n- dirhdl #)
   2dup '_' scan  dup if 1 /string then
   dup >R 2swap R> - 2swap 2over d/o open-dir ;

: DIREND-NEXT   ( a n dirhdl -- dir-a #f/0)
   >R 0 begin   drop R@ read-dir 0=
   while        dup 2over rot
                >fname count dir/same ?dup
   until else   0
   then         2swap 2drop R> drop ;

: DIRC         ( --)
               bl word count dirend-open throw
   begin       dup 2over rot dirend-next
   while       dup >fsize        2@ 8 d.r space
               dup >ftime&date   swap rot
                                 0 <# # # 2drop
                                    0 # # 2drop 0 # # #>
                                 type space drop 2drop
               dup >fattr c@ 1 = if '*' else bl then
                                 emit space
                   >fname count  type cr  ?esc ?dup
   until then  drop close-dir throw 2drop 2drop ;

variable OPTION-LINK
   ( ** link-data: cfa=val$ link char/cfg char/group)

char C constant 'C'
char E constant 'E'
char T constant 'T'

: 'OPTION,      ( char/cfg char/group --  // 'name')
   ' , option-link up-link-in
   swap capital c, capital c, align ;

: $OPTION       ( char/cfg --)      'C' 'option, ;
: CMD-OPTION    ( char/cfg --)      'E' 'option, ;

: OPTION-SET?   ( a -- f)
             option-link
   begin     @ dup
   while     2dup 1 cells - @ =
             over cell+ 1+ c@ 'T' = and
   until     2drop -1  exit
   then      2drop  0 ;

      0 value CFG?
      0. $=   ZERO$
' zero$ value LAST-PATH
' zero$ value LAST-ENDING

: ENDING>   ( -- // 'name')     ' to last-ending ;
: PATH>     ( -- // 'name')     ' to last-path   ;

: IS-PATHNAME   ( a/buf n -- a n)
   '_' -skip dup
   if 2dup + '_' swap c! 1+ then ;

: IS-ROOTNAME   ( a/buf n -- a n)  is-pathname ;

: ADD-PATH?     ( a n cfa/0 -- a/buf n)
   pathscrt 0 rot
   ?dup if   ( a 0 ) execute ( a 0 a n)
             '_' -skip
   ?dup if   2swap append is-pathname else drop
   then then append ;

: ADD-ENDING?   ( a/buf n cfa -- a/buf n)
   ?dup if  ( a n) execute ( a n a n)
            '_' skip '_' -skip
   ?dup if  2swap is-rootname append exit
   then drop then ;

: '$FSPEC   ( --)
            create no$ , last-path , last-ending ,

   DOES>    ( -- a n)
            ( ** data: adr-of-$ cfa/path cfa/ending)
              dup @ count
   rot  cell+ dup @
   swap cell+     @
   >R add-path?   R> add-ending? ;

: +CFG-DEF?     ( n --)
   cfg? 0= if drop exit then
   dup  >in ! '
   swap >in ! cfg-wid xcreate ,

   DOES>        ( -- // ** data: cfa=$val/$fspec)
   word-in rot @ dup option-set? 0= $to? ;

: CFG-ON                -1 to cfg? ;
: CFG-OFF                0 to cfg? ;

: $VAL      ( --)       >in @ '$val   +cfg-def? ;
: $FSPEC    ( --)       >in @ '$fspec +cfg-def? ;

: SET-OPTION    ( a n char --)
   capital      option-link
   begin        @ ?dup
   while        2dup cell+    c@ =
                over cell+ 1+ c@ 'T' - and
   until        nip dup 1 cells - @
                swap cell+ 1+
                dup c@ 'C' =
                'T' rot c!
      if        over $to?  exit
      then      execute    exit
   then         drop 2drop ;

: IS-ESC$?      ( a n -- a n -1 // 0)
   over c@ dup '/' = swap '-' = or over and
   if 1 /string dup if -1 exit then then 2drop 0 ;

: ESCAPE?       ( -- a n char -1 // 0)
   begin    word-in dup  while is-esc$?
   until    over swap 1 /string
            rot c@   -1 exit     then nip ;

: ESC-CATCH     ( -- err#)
   >in @ >R     begin escape?
   while ['] set-option catch ?dup
   until else 0 then R> >in ! ;

: COMMAND?      ( -- a$ -1 // 0)
   begin    bl word dup c@
   while    dup count is-esc$?
   while    2drop drop
   repeat   -1 exit then drop 0 ;

: CMD-CATCH     ( -- err# -1 // $a 0)
                ( ** a$=no$ if input was empty)
   0. begin     nip command?
   while        nip find
   while        catch -1 over
   until             exit
   then         0    exit
   then         if 0 -1 else no$ 0 then ;

\ - Logfile Interface -----------------------------------------

\ ISLLEV!   >> Set maximum level to write,
\             marked correspondingly by one of: !+*-#:
\ LOG-OPEN  >> Start logging. Elsewise, if handle is 0,
\             output to console.
\ LOG-CLOSE >> Close logfile.
\ >LOGLINE  >> Start of a line.
\             Given a string, return the next log line.
\             To this string items may be appended.
\ LOG-OUT   >> Set loglevel for the created line
\             and write conditionally.
\          Provide strings for LOGSHORT LOGLONG LOGFILE

\ .INFO     >> Write a string to console,
\             but first wipe out what has been written last.

variable OLAST

create BL$  here 16 dup allot bl fill

: BACKSPACES    ( n --)
   ?dup if 0 do del loop then ;

: .INFO         ( a n --)
   olast @ backspaces tuck type olast ! ;

  0 value    LOGHDL
  0 value    ISLLEV
  5 constant DEFLLEV

cfg-on  $val LOGFILE
cfg-off $val LOGSHORT
        $val LOGLONG

s" End " $= 'end'

:noname     create
   DOES>    ( # -- char -1 // 0)
            over 0<
   if       nip count 1- + c@ -1 exit
   then     1+ isllev rot tuck u<
   if       2drop 0 exit
   then     + c@ -1 ;

s" !+*-#: " rot execute LOG-CHAR? $alloc align

: ISLLEV!       ( n --)
   ['] log-char? >body c@  over u<
   if drop defllev then to isllev ;

: >LOG-T&D$   ( ss...yy -- a n  )
              ( ** "_dd_mmm_hh:mm:ss_")
   drop 2>R <#  bl hold time>pad
        2R> month$-hold bl ##b-hold 0. #> ;

: >LOGLINE      ( a n -- a n)
   logscrt 1
   time&date >log-t&d$ append>
   logshort append>    append ;

: LOG-OUT       ( a n # --)
         log-char?
   if    >R over R> swap c!
         loghdl ?dup
   if    write-line throw exit
   then  type cr          exit
   then  2drop ;

: LOG-CLOSE     ( --)
   loghdl if  'end' >logline
   [ ' log-char? >body ] literal count
                     append> -1 log-out
   loghdl close-file throw 0 to loghdl then ;

: LOG-OPEN     ( --)
                logfile dup
   if           2dup r/w open-file
      if        drop r/w create-file throw
      else      >R 2drop
                R@ file-size throw
                R@ reposition-file throw
                0. R@ write-line throw R>
      then
   else         2drop 0
   then         to loghdl
                loglong >logline -1 log-out ;

\ - indexing interface ----------------------------------------

\ IXMAKE   >> provide record size n [ 2^lb[n] < 1024 ],
\            and an ID-number.
\ IXDROP   >> close file and delete.

\ Filename is derived from ID-number 0...48000, this gives
\ a filename-ending of "000" up to "ZZZ".
\ Provide a pathname:    <name> $TO TMPPATH
\ In configuration file: TMPPATH <name>
\ Via commandline:       /T<name>

\ IXUPDATE >> mark record if written to.
\ #>IDX    >> calculate from record number to data space.

\ Provide index-handle returned by IXMAKE to all calls.

\    1024 constant B/BLK
\ : BLK-UM*   b/blk um* ;

variable LAST-IDX#
variable TMP-IDX#

: #>ENDING       ( -- a n)
   base @ >R     36 base ! tmp-idx# @
   0 <# # # # #> R> base ! ;

: ?IDX      0= abort" index out of bounds" ;
: HALF+     1 rshift over + ;

cfg-on  $val TMPPATH
cfg-off

path>   tmppath
ending> #>ending

$fspec  IDXFNAME
   s" $$user" $to idxfname

path>   zero$
ending> zero$

:noname    create , DOES> @ + ;

0 cells over execute IDX>HDL
1 cells over execute IDX>#NAME
2 cells over execute IDX>BLK#
3 cells over execute IDX>UPD
4 cells over execute IDX>AND
5 cells over execute IDX>MOD
6 cells over execute IDX>DIV
7 cells over execute IDX>COUNT
8 cells over execute IDX>LIM
9 cells over execute IDX>BLOCK   drop

9 cells b/blk + constant IDX-SIZE

: 'IDX-RECSET   ( #rec ix --)
   >R  logbin      b/blk logbin
   2dup u< ?idx    over -
   1 over lshift   1- R@ idx>and !
   swap R@ idx>mod !  R> idx>div ! ;

: IXMAKE        ( #rec n=name -- ix)
   idx-size dup   allocate throw
   dup rot 0 fill >R
   dup tmp-idx# ! R@ idx>#name !
   R@ idxfname    r/w create-file throw
   R@ idx>hdl !   R@ 'idx-recset  R> ;

: IXDROP        ( ix --)
   dup >R idx>hdl @ close-file throw
   R@ idx>#name @ tmp-idx# !
   idxfname delete-file throw
   R> free throw ;

: IX-R/W        ( # ix f --)
   >R dup idx>block b/blk rot idx>hdl @ >R
   rot blk-um* R@ reposition-file throw R> R>
   if read-file nip else write-file then throw ;

: IXUPDATE      ( ix --)
   -1 swap idx>upd ! ;

: IXWRITE?      ( ix --)
        dup idx>upd @
   if   dup idx>blk# @  over 0 ix-r/w
      0 over idx>upd !  then drop ;

: IXREAD        ( # ix -- a/data)
   2dup idx>blk# @ =    if nip
   else dup ixwrite?    2dup idx>blk# !
   tuck -1 ix-r/w       then idx>block ;

: #>IDX         ( # ix -- a)
   tuck 2dup idx>and @ and    over idx>mod @
   lshift >R idx>div @ rshift swap ixread  R> + ;

\ - macro-interpret -------------------------------------------

\ SOLVE-MACTEXT >> interpret text clause up to next '---'

\ SKIP-MACCOND  >> skip past next '---'
\ NO-COND       >> skip past next '<END' or '<REP'
\ FILE>MSG      >> copy file

\ macro-words so long:  % --- TAB TAB+ <END

\ Defined macrowords in wordlist MAC-WID are later on found
\ by leading '%' in macrotext and executed, a trailing sign is
\ recognized and appended.

\ Start conditional clauses by definition names ending with '>'.
\ Avoid definition names which differ only in one extra letter.

    wordlist constant MAC-WID

0 value  MSGHDL
variable MSGAT

: MSG-WRITE     ( a n --)
   msghdl ?dup
   if over msgat +! write-file throw exit then 2drop ;

: MSG-SPACES    ( n -- )
   ?dup if      dup 15 and swap 4 rshift
   ?dup if 0 do bl$ 16 msg-write
   loop then    bl$ swap msg-write then ;

variable CHARSCRT
variable MACCHAR

: MSG-CHAR      ( b --)
   charscrt c! charscrt 1 msg-write ;

: MSG-CR        ( --)
   #cr msg-char 0 msgat ! ;

: MSG-OUT       ( a n --)
   ?dup if    msg-write  macchar @
   ?dup       if      msg-char 0 macchar !
              then bl msg-char exit
   then       drop ;

                    get-current mac-wid set-current
: (             postpone ( ; immediate
: \             postpone \ ; immediate
: ---           ;
: <END          ;
: <REP          ;
: SWITCH>       ;
: MACRO>        ;                       set-current

                         get-order mac-wid +order
' ---     constant '---
' <end    constant '<END
' <rep    constant '<REP                set-order

                    get-current mac-wid set-current
: TAB
   >in @ bl word count $>#?
   if nip msgat @ - 0 max msg-spaces exit
   then >in ! ;

: TAB+
   >in @ bl word count $>#?
   if nip >R   msgat @ 0
      R@ um/mod nip 1+ R> um* drop
      msgat @ - 0 max msg-spaces exit
   then >in ! ;
                    set-current

: NOMACSKIP?    ( -- -1/0/1)
           /source 0= over c@ bl = or
   if drop -1 exit then c@ '%' =
   if       1 exit then    0 ;

: NOMACRO?      ( -- -1/0/1)
   nomacskip? dup       if dup 0<
   if       msg-cr exit
   then '%' msg-char    then ;

: IS-COND?      ( cfa -- 0/1/2)
   '<end case? if 1 exit then
   '<rep =     if 2 exit then 0 ;

: MAC-SEARCH    ( a n -- cfa -1/1 -1 // a n 0)
                2dup mac-wid search-wordlist
   if           rot rot + 1- c@ '>' =
                if -1 else 1 then -1 exit
   then         0 ;

: MAC-FIND      ( -- cfa -1/1 // 0)
                bl word count dup
   if           mac-search if exit then
                1- dup
      if        2dup + c@ >R
                mac-search if R> macchar ! exit then
                R> drop
   then then    2drop 0 ;

: MACTEXT-END?  ( -- f)
           >in @     mac-find
   if      '--- = over 0= and
      if   drop -1 exit     then then >in ! 0 ;

: MACCOND-END?  ( -- f)
             >in @  mac-find
   if      '--- = over 0= and
      if     >in ! -1 exit  then then >in !  0 ;

: MACRO-VAR     ( --)           -1 abort" no macro" ;

: MACRO-EXE     ( --)
   mac-find if execute exit then macro-var ;

: SOLVE-MACTEXT ( hdl --)
                to msghdl
   begin        mactext-end? 0=
   while begin  /source
                over swap   '%' scan >R
                over - tuck msg-write R>
      while     1+ >in +!
                nomacro? 0=
                if macro-exe then
      repeat    drop    refill 0=
   until then   0 to msghdl ;

: NO-COND       ( -- 2/1/0/-1)
   begin        maccond-end? 0=
   while begin  /source
                over swap '%' scan
                >R swap - R>
      while     1+ >in +!
                nomacskip? 0=
        if      mac-find
          if    is-cond?
                ?dup if exit then
        then then
      repeat    drop refill 0=
   until 0      else -1 then ;

: SKIP-MACTEXT  ( -- noend)
   begin        mactext-end? 0=
   while        refill       0=
   until 0 else -1 then ;

: FILE>MSG      ( hdl --)
   ?dup if >R   0. R@ reposition-file throw
   msg-cr begin R@ get-line
   while        msg-write msg-cr
   repeat       R> drop then ;

