\ sintable
\ CALC'D BY:  Michael Coughlin  mikc@gnu.ai.mit.edu
\ PI = 3.141592653589793238462643383279
\ Sine of an angle, 0 to 89 degrees for each degree, base 16
\ Orig'ly 1 to 90 degrees.
\
\ Multiply <m> with sine of angle <n> without loss of accuracy
\  - supposed full 32 bit double cell arithmetics -
\  <m> <n>   >SINE   ROT TU*   ROT DROP   (giving 64 bit result)
\            or: .......       ROT 0< IF 1. D+ THEN
\
\  Multiply with sine giving single cell result
\  <m> <n>   >SINE NIP   UM* NIP
\            or: .......     SWAP 0< IF 1+ THEN
\
\  Get COSINE of angle:       <n> 90 SWAP - >SINE
( lines & circles)

( ** Copyright @ Ewald Pfau, 1994. Fidonet: 2:316/9.0 **
  - except for sine table.

Distribution only with the unchanged version of this file
at least as a part of what is distributed. )

     decimal marker nosines

   2  5  thru  \ +DRAW   - drawing lines; needs set-pix

      8  load  \ >SINE   - load sine table, 0..89 deg, 64 bit

   6  7  thru  \ VEC>XY  - vectors to circle coordinates

\ draw lines                                           23Apr94ep

                get-order also editor
: SET-PIX  ( x y --) 16 tab+ swap 4 u.r 4 u.r  ;
                set-order
: */       >R m* R> sm/rem nip ;

: XLOOP-COORD   ( x0 y0 xdiff ydiff x+ -- 'x 'y)
   dup >R swap rot */ +
   swap R> + swap ;

: YLOOP-COORD   ( x0 y0 xdiff ydiff y+ -- 'x 'y)
   dup >R rot rot */ rot +
   swap R> + ;


\ draw lines                                           23Apr94ep

: +LINE-X       ( x0 y0 xdiff --)
   1+ 0 ?do over I + over set-pix loop 2drop ;

: +DRAW-X       ( x0 y0 xdiff ydiff --)
   over 1+ 0 do 2over 2over I xloop-coord
   set-pix   loop  2drop 2drop ;

: +LINE-Y       ( x0 y0 ydiff --)
   0 1+ ?do 2dup I + set-pix loop 2drop ;

: +DRAW-Y       ( x0 y0 xdiff ydiff --)
   dup 1+ 0 do  2over 2over I yloop-coord
   set-pix   loop  2drop 2drop ;

\ draw lines                                           23Apr94ep

: DRAW-X-OR-Y   ( x y x y -- f)
                ( ** xdiff same/above ydiff ?)
   rot swap  2dup u< if swap then - >R
             2dup u< if swap then - R> u< 0= ;

: 'DRAW-TWIST   ( x y x y f -- x y x y)
                ( ** swap for positive count on draw axis)
   >R         2over 2over
   rot        ( y21)  u< R@ 0= and
   swap rot   ( x21)  u< R>    and
   or         if 2swap then ;



\ draw lines                                           23Apr94ep

: DRAW-DIFFS    ( x y x y -- x0 y0 xdiff ydiff)
   2over 2swap rot - >R swap - R> ;

: DRAW-TWIST    ( x y x y -- x0 y0 xdiff ydiff f)
   2over 2over draw-x-or-y
   dup >R 'draw-twist draw-diffs R> ;

: +DRAW         ( xy> >xy --)
   draw-twist
   if    dup   if +draw-x else drop +line-x then
   else  over  if +draw-y else nip  +line-y then then ;



\ circles                                              04May94ep

90 constant #VEC/Q

: +XCORR ( scaling if desired) ;

: VEC-Q-ADD     ( x0 y0  z1 z2  0..3  --  x+ y+)
                ( ** Quadrant 0 >> top right ; counterclock)
                ( ** A[ x*sin & y*cos ] || B[ x*cos & y*sin] )

                              ( y ......... x )
   0 case? if   ( B ) rot rot   + >R +xcorr + R> else
   1 case? if   ( A ) rot swap  + >R +xcorr - R> else
   2 case? if   ( B ) rot rot   - >R +xcorr - R> else
   3 case? if   ( A ) rot swap  - >R +xcorr + R> else
                drop 2drop   then then then then ;
\ circles                                              04May94ep

: VEC-MUL       ( vec 0..89 -- z)
   >sine nip um* swap if 1+ then ;

: VEC-IN-Q      ( vec 0..89 -- z1 z2)
                ( ** skip: cos[0 deg] = 1)
   2dup vec-mul   rot rot dup
   if   #vec/q swap - vec-mul else drop then ;

: VEC>XY        ( x0 y0 0vec 0..359 -- x+ y+)
   0 #vec/q um/mod 3 and >R
   vec-in-q R> vec-q-add ;

: +CDOTS        ( x0 y0 vec --)    360 0
   do dup 2over rot i vec>xy set-pix 15 +loop drop 2drop ;
\ load sine table

:noname         base @ >R hex
   90 0 do      0.
      begin     bl word count ?dup 0=
      while     drop refill        0= abort" ?hmpfr?"
      repeat    1 /string >number nip abort" garbage"
                here 2 cells allot 2!
   loop         R> base ! ;

:noname         create
   DOES>        swap 3 lshift + 2@ ;

execute >SINE
execute


.0000000000000000 .0477C2CAE2774795 .08EF2C64FBEE13AC
.0D65E3A477E486DC .11DB8F6D6A5127E0 .164FD6B8C281028C
.1AC2609B3C576C09 .1F32D44C4F62D35B .23A0D92D1B3C3272
.280C16CF50A6E9FF .2C7434FC16E71344 .30D8DBBAECC49E92
.3539B35884B1EB98 .3996646D9B8CE99A .3DEE97E5C9723973
.4241F7064C1A41A3 .46902B74CA38A599 .4AD8DF3E0F571D04
.4F1BBCDCBFA53E07 .53586F4003376DBD .578EA1D2282FD570
.5BBE007F3B4CF05B .5FE637BB965A0579 .6406F48A63FEAAD1
.681FE484186B43F2 .6C30B5DCDE614B9D .7039176AF81720F7
.7438B8AD1378030D .782F49D09141E1D5 .7C1C7BB7BE83B1DC
.7FFFFFFFFFFFFFFB .83D98907EEF89BE9 .87A8C9F566E953D1
.8B6D76BB83B8E7D5 .8F2744208FE89299 .92D5E7C3E24BC36B
.96791823AAD2EF68 .9A108CA2ADF5B0E2 .9D9BFD8DEE49C71C
.A11B242243D5EC6D .A48DBA91E0B0E557 .A7F37C09C27EA09F
.AB4C24B7105EBE44 .AE9771CC64E159B3 .B1D5218703988253

.B504F333F9DE647E .B826A7352A69C431 .BB39FF06434C11AA
.BE3EBD419DF60F52 .C134A5A508E1B6D1 .C41B7D167A81C98B
.C6F309A8AD193E68 .C9BB129FA31E8BD5 .CC73607513D0A135
.CF1BBCDCBFA53E05 .D1B3F2C8AC3A3756 .D43BCE6D477524DE
.D6B31D45717EDE7D .D919AE166D4A28F5 .DB6F50F3B756ECA7
.DDB3D742C2655398 .DFE713BE99CE343D .E208DA7B69383CA3
.E41900E9E963655A .E6175DDAB1C64CC0 .E803C9816EBB39E5
.E9DE1D77FBFCAA10 .EBA634C163337492 .ED5BEBCCBE5ABE4A
.EEFF2077FDC0286A .F08FB2129168DCD2 .F20D815FF5A65567
.F378709A22A7FAEF .F4D06373DED8FB49 .F6153F1AF3DBFDA9
.F746EA3A45F8A626 .F8654CFBCDD127F1 .F970510A743876BC
.FA67E193D003FC52 .FB4BEB49C5B60E63 .FC1C5C6408E0BACD
.FCD924A17F22DCCF .FD82354984A3CC9C .FE17812D11F45BBA
.FE98FCA7C33E3362 .FF069DA0C0AD0F10 .FF605B8B87FFB398
.FFA62F689730EAEB .FFD813C5F82B35AE .FFF604BFAD7C4DCE
